/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.result;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.level.IHasErrorLevel;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.phive.api.result.ValidationResult;
import com.helger.phive.api.source.IValidationSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ValidationResultList
extends CommonsArrayList<ValidationResult> {
    private final IValidationSource m_aSource;

    public ValidationResultList(@Nullable IValidationSource iValidationSource) {
        this.m_aSource = iValidationSource;
    }

    public final boolean hasValidationSource() {
        return this.m_aSource != null;
    }

    @Nullable
    public final IValidationSource getValidationSource() {
        return this.m_aSource;
    }

    public boolean containsNoFailure() {
        return this.containsNone(validationResult -> validationResult.getErrorList().containsAtLeastOneFailure());
    }

    public boolean containsNoError() {
        return this.containsNone(validationResult -> validationResult.getErrorList().containsAtLeastOneError());
    }

    public boolean containsAtLeastOneFailure() {
        return this.containsAny(validationResult -> validationResult.getErrorList().containsAtLeastOneFailure());
    }

    public boolean containsAtLeastOneError() {
        return this.containsAny(validationResult -> validationResult.getErrorList().containsAtLeastOneError());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getAllFailures() {
        ErrorList errorList = new ErrorList();
        this.forEachFlattened(IHasErrorLevel::isFailure, arg_0 -> errorList.add(arg_0));
        return errorList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ErrorList getAllErrors() {
        ErrorList errorList = new ErrorList();
        this.forEachFlattened(IHasErrorLevel::isError, arg_0 -> errorList.add(arg_0));
        return errorList;
    }

    @Nonnegative
    public int getAllCount(@Nullable Predicate<? super IError> predicate) {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ValidationResult validationResult = (ValidationResult)iterator.next();
            n += validationResult.getErrorList().getCount(predicate);
        }
        return n;
    }

    public void forEachFlattened(@Nonnull Consumer<? super IError> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ValidationResult validationResult = (ValidationResult)iterator.next();
            validationResult.getErrorList().forEach(consumer);
        }
    }

    public void forEachFlattened(@Nullable Predicate<? super IError> predicate, @Nonnull Consumer<? super IError> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ValidationResult validationResult = (ValidationResult)iterator.next();
            validationResult.getErrorList().findAll(predicate, consumer);
        }
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Source", (Object)this.m_aSource).getToString();
    }
}

