/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.schematron;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.string.StringHelper;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.wrapper.Wrapper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.EValidationType;
import com.helger.phive.api.IValidationType;
import com.helger.phive.api.artefact.IValidationArtefact;
import com.helger.phive.api.artefact.ValidationArtefact;
import com.helger.phive.api.execute.IValidationExecutorCacheSupport;
import com.helger.phive.api.executor.AbstractValidationExecutor;
import com.helger.phive.api.result.ValidationResult;
import com.helger.phive.xml.schematron.CustomErrorDetails;
import com.helger.phive.xml.schematron.ESchematronOutput;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.SchematronResourceHelper;
import com.helger.schematron.pure.SchematronResourcePure;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.errorhandler.WrappedCollectingPSErrorHandler;
import com.helger.schematron.sch.SchematronResourceSCH;
import com.helger.schematron.schxslt.xslt2.SchematronResourceSchXslt_XSLT2;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.SVRLResourceError;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.transform.WrappedCollectingTransformErrorListener;
import com.helger.xml.xpath.XPathExpressionHelper;
import com.helger.xml.xpath.XPathHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ValidationExecutorSchematron
extends AbstractValidationExecutor<IValidationSourceXML, ValidationExecutorSchematron>
implements IValidationExecutorCacheSupport {
    public static final String IN_MEMORY_RESOURCE_NAME = "in-memory-data";
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationExecutorSchematron.class);
    private final String m_sPrerequisiteXPath;
    private final MapBasedNamespaceContext m_aNamespaceContext;
    private boolean m_bCacheSchematron = true;
    private ICommonsMap<String, CustomErrorDetails> m_aCustomErrorDetails;

    public ValidationExecutorSchematron(@Nonnull IValidationArtefact iValidationArtefact, @Nullable String string, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        super(iValidationArtefact);
        ValueEnforcer.isTrue(() -> iValidationArtefact.getValidationType().getBaseType().isSchematron(), (String)"Artifact is not a Schematron");
        this.m_sPrerequisiteXPath = string;
        this.m_aNamespaceContext = iIterableNamespaceContext == null ? null : new MapBasedNamespaceContext(iIterableNamespaceContext);
    }

    @Nullable
    public final String getPrerequisiteXPath() {
        return this.m_sPrerequisiteXPath;
    }

    @Nullable
    @ReturnsMutableObject
    public final MapBasedNamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext == null ? null : this.m_aNamespaceContext.getClone();
    }

    public final boolean isCacheArtefact() {
        return this.m_bCacheSchematron;
    }

    @Nonnull
    public final ValidationExecutorSchematron setCacheArtefact(boolean bl) {
        this.m_bCacheSchematron = bl;
        return this;
    }

    public void ensureItemIsInCache() {
        if (this.m_bCacheSchematron) {
            AbstractSchematronResource abstractSchematronResource = this._createSchematronResource(null, new ErrorList(), eSchematronOutput -> {});
            abstractSchematronResource.setUseCache(true);
            abstractSchematronResource.isValidSchematron();
            LOGGER.debug("ValidationExecutorSchematron " + this.getValidationArtefact().getRuleResourcePath() + " is now in the cache");
        }
    }

    @Nonnull
    public final ValidationExecutorSchematron addCustomErrorDetail(@Nonnull @Nonempty String string, @Nonnull CustomErrorDetails customErrorDetails) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ErrorID");
        ValueEnforcer.notNull((Object)customErrorDetails, (String)"ErrorDetails");
        if (this.m_aCustomErrorDetails == null) {
            this.m_aCustomErrorDetails = new CommonsHashMap();
        }
        this.m_aCustomErrorDetails.put((Object)string, (Object)customErrorDetails);
        return this;
    }

    @Nonnull
    public final ValidationExecutorSchematron addCustomErrorDetails(@Nullable Map<String, ? extends CustomErrorDetails> map) {
        if (map != null && !map.isEmpty()) {
            if (this.m_aCustomErrorDetails == null) {
                this.m_aCustomErrorDetails = new CommonsHashMap();
            }
            this.m_aCustomErrorDetails.putAll(map);
        }
        return this;
    }

    @Nonnull
    private AbstractSchematronResource _createSchematronResource(@Nullable Locale locale, @Nonnull ErrorList errorList, @Nonnull Consumer<ESchematronOutput> consumer) {
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        IReadableResource iReadableResource = iValidationArtefact.getRuleResource();
        IValidationType iValidationType = iValidationArtefact.getValidationType();
        if (iValidationType == EValidationType.SCHEMATRON_PURE) {
            SchematronResourcePure schematronResourcePure = new SchematronResourcePure(iReadableResource);
            schematronResourcePure.setErrorHandler((IPSErrorHandler)new WrappedCollectingPSErrorHandler(errorList));
            return schematronResourcePure;
        }
        if (iValidationType == EValidationType.SCHEMATRON_SCH) {
            SchematronResourceSCH schematronResourceSCH = new SchematronResourceSCH(iReadableResource);
            schematronResourceSCH.setErrorListener((ErrorListener)new WrappedCollectingTransformErrorListener(errorList));
            if (locale != null && StringHelper.isNotEmpty((String)locale.getLanguage())) {
                schematronResourceSCH.setLanguageCode(locale.getLanguage());
            }
            return schematronResourceSCH;
        }
        if (iValidationType == EValidationType.SCHEMATRON_SCHXSLT) {
            SchematronResourceSchXslt_XSLT2 schematronResourceSchXslt_XSLT2 = new SchematronResourceSchXslt_XSLT2(iReadableResource);
            schematronResourceSchXslt_XSLT2.setErrorListener((ErrorListener)new WrappedCollectingTransformErrorListener(errorList));
            if (locale != null && StringHelper.isNotEmpty((String)locale.getLanguage())) {
                schematronResourceSchXslt_XSLT2.setLanguageCode(locale.getLanguage());
            }
            return schematronResourceSchXslt_XSLT2;
        }
        if (iValidationType == EValidationType.SCHEMATRON_XSLT) {
            SchematronResourceXSLT schematronResourceXSLT = new SchematronResourceXSLT(iReadableResource);
            schematronResourceXSLT.setErrorListener((ErrorListener)new WrappedCollectingTransformErrorListener(errorList));
            return schematronResourceXSLT;
        }
        if (iValidationType == EValidationType.SCHEMATRON_OIOUBL) {
            SchematronResourceXSLT schematronResourceXSLT = new SchematronResourceXSLT(iReadableResource);
            schematronResourceXSLT.setErrorListener((ErrorListener)new WrappedCollectingTransformErrorListener(errorList));
            consumer.accept(ESchematronOutput.OIOUBL);
            return schematronResourceXSLT;
        }
        throw new IllegalStateException("Unsupported Schematron validation type: " + String.valueOf(iValidationType));
    }

    @Nonnull
    public ValidationResult applyValidation(@Nonnull IValidationSourceXML iValidationSourceXML, @Nullable Locale locale) {
        String string;
        Object object;
        Object object22;
        Object object3;
        Document document;
        Object object4;
        Object object5;
        ValueEnforcer.notNull((Object)iValidationSourceXML, (String)"Source");
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        StopWatch stopWatch = StopWatch.createdStarted();
        Node node = null;
        try {
            node = SchematronResourceHelper.getNodeOfSource((Source)iValidationSourceXML.getAsTransformSource(), (DOMReaderSettings)new DOMReaderSettings());
        }
        catch (Exception exception) {
            throw new IllegalStateException("For Schematron validation to work, the source must be valid XML which it is not.", exception);
        }
        if (StringHelper.isNotEmpty((String)this.m_sPrerequisiteXPath)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using Schematron prerequisite path '" + this.m_sPrerequisiteXPath + "'");
            }
            object5 = XPathHelper.createNewXPath();
            if (this.m_aNamespaceContext != null) {
                object5.setNamespaceContext((NamespaceContext)this.m_aNamespaceContext);
            }
            try {
                object4 = XPathExpressionHelper.evalXPathToBoolean((XPath)object5, (String)this.m_sPrerequisiteXPath, (Document)XMLHelper.getOwnerDocument((Node)node));
                if (object4 != null && !((Boolean)object4).booleanValue()) {
                    LOGGER.info("Ignoring validation artefact " + iValidationArtefact.getRuleResourcePath() + " because the prerequisite XPath expression '" + this.m_sPrerequisiteXPath + "' is not fulfilled.");
                    return ValidationResult.createSkippedResult((IValidationArtefact)iValidationArtefact);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "Failed to verify if validation artefact " + iValidationArtefact.getRuleResourcePath() + " matches the prerequisite XPath expression '" + this.m_sPrerequisiteXPath + "' - ignoring validation artefact.";
                LOGGER.error(string2, (Throwable)illegalArgumentException);
                return this.createValidationResult((IErrorList)new ErrorList(new IError[]{((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builderError().errorText(string2)).linkedException((Throwable)illegalArgumentException)).build()}), stopWatch.stopAndGetMillis());
            }
        }
        object5 = new ErrorList();
        object4 = new Wrapper((Object)ESchematronOutput.SVRL);
        AbstractSchematronResource abstractSchematronResource = this._createSchematronResource(locale, (ErrorList)object5, arg_0 -> ((Wrapper)object4).set(arg_0));
        abstractSchematronResource.setUseCache(this.m_bCacheSchematron);
        try {
            document = abstractSchematronResource.applySchematronValidation((Source)new DOMSource(node));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SVRL: " + XMLWriter.getNodeAsString((Node)document));
            }
            switch ((ESchematronOutput)((Object)object4.get())) {
                case SVRL: {
                    Object object6 = object3 = document == null || document.getDocumentElement() == null ? null : (SchematronOutputType)new SVRLMarshaller().read((Node)document);
                    if (object3 != null) {
                        for (Object object22 : SVRLHelper.getAllFailedAssertions(object3)) {
                            object5.add((Object)object22.getAsResourceError(iValidationSourceXML.getSystemID()));
                        }
                        for (Object object22 : SVRLHelper.getAllSuccessfulReports((SchematronOutputType)object3)) {
                            object5.add((Object)object22.getAsResourceError(iValidationSourceXML.getSystemID()));
                        }
                        break;
                    }
                    LOGGER.warn("Failed to read the result as SVRL:" + (String)(document != null ? "\n" + XMLWriter.getNodeAsString((Node)document) : " no XML Document created"));
                    object5.add((Object)((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builderError().errorLocation(iValidationArtefact.getRuleResourcePath())).errorText("Internal error interpreting Schematron result")).errorFieldName(document != null ? XMLWriter.getNodeAsString((Node)document) : null)).build());
                    break;
                }
                case OIOUBL: {
                    if (document != null && document.getDocumentElement() != null) {
                        for (Object object7 : XMLHelper.getChildElementIterator((Node)document.getDocumentElement(), (String)"Error")) {
                            object22 = XMLHelper.getFirstChildElementOfName((Node)object7, (String)"Pattern").getTextContent();
                            object = XMLHelper.getFirstChildElementOfName((Node)object7, (String)"Description").getTextContent();
                            string = XMLHelper.getFirstChildElementOfName((Node)object7, (String)"Xpath").getTextContent();
                            object5.add((Object)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)new SVRLResourceError.SVRLErrorBuilder((String)object22).errorLocation((ILocation)new SimpleLocation(iValidationSourceXML.getSystemID()))).errorText((String)object)).errorFieldName(string)).build());
                        }
                        break;
                    }
                    LOGGER.warn("Failed to read the result as OIOUBL result:" + (String)(document != null ? "\n" + XMLWriter.getNodeAsString((Node)document) : " no XML Document created"));
                    object5.add((Object)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builderError().errorLocation(iValidationArtefact.getRuleResourcePath())).errorText("Internal error - no Schematron output created for OIOUBL")).build());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported output type");
                }
            }
        }
        catch (Exception exception) {
            object5.add((Object)((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builderError().errorLocation(iValidationArtefact.getRuleResourcePath())).errorText(exception.getMessage())).linkedException((Throwable)exception)).build());
        }
        if (this.m_aCustomErrorDetails != null && object5.isNotEmpty()) {
            document = object5.getClone();
            object5.clear();
            object3 = document.iterator();
            while (object3.hasNext()) {
                Object object7;
                object7 = (IError)object3.next();
                object22 = object7.getErrorID();
                object = (CustomErrorDetails)this.m_aCustomErrorDetails.get(object22);
                if (object != null) {
                    string = ((CustomErrorDetails)object).getErrorLevel();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Changing error level of '" + (String)object22 + "' from " + object7.getErrorLevel().getNumericLevel() + " to " + String.valueOf(string) + " (" + string.getNumericLevel() + ")");
                    }
                    object5.add((Object)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builder((IError)object7).errorLevel((IErrorLevel)string)).errorText(((CustomErrorDetails)object).getWithErrorTextPrefixAndSuffixApplied(object7.getErrorText(Locale.ROOT)))).build());
                    continue;
                }
                object5.add(object7);
            }
        }
        return this.createValidationResult((IErrorList)object5, stopWatch.stopAndGetMillis());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ValidationExecutorSchematron getClone() {
        ValidationExecutorSchematron validationExecutorSchematron = new ValidationExecutorSchematron(this.getValidationArtefact(), this.m_sPrerequisiteXPath, (IIterableNamespaceContext)this.m_aNamespaceContext);
        validationExecutorSchematron.setStopValidationOnError(this.isStopValidationOnError());
        validationExecutorSchematron.setCacheArtefact(this.m_bCacheSchematron);
        if (this.m_aCustomErrorDetails != null) {
            validationExecutorSchematron.addCustomErrorDetails((Map)this.m_aCustomErrorDetails.getClone());
        }
        return validationExecutorSchematron;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ValidationExecutorSchematron validationExecutorSchematron = (ValidationExecutorSchematron)((Object)object);
        return this.m_bCacheSchematron == validationExecutorSchematron.m_bCacheSchematron && EqualsHelper.equals((Object)this.m_sPrerequisiteXPath, (Object)validationExecutorSchematron.m_sPrerequisiteXPath) && EqualsHelper.equals((Object)this.m_aNamespaceContext, (Object)validationExecutorSchematron.m_aNamespaceContext) && EqualsHelper.equals(this.m_aCustomErrorDetails, validationExecutorSchematron.m_aCustomErrorDetails);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bCacheSchematron).append((Object)this.m_sPrerequisiteXPath).append((Object)this.m_aNamespaceContext).append(this.m_aCustomErrorDetails).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("CacheSchematron", this.m_bCacheSchematron).appendIfNotNull("PrerequisiteXPath", (Object)this.m_sPrerequisiteXPath).appendIfNotNull("NamespaceContext", (Object)this.m_aNamespaceContext).appendIfNotNull("CustomErrorLevels", this.m_aCustomErrorDetails).getToString();
    }

    @Nonnull
    public static ValidationExecutorSchematron createPure(@Nonnull IReadableResource iReadableResource, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.SCHEMATRON_PURE, iReadableResource), null, iIterableNamespaceContext);
    }

    @Nonnull
    public static ValidationExecutorSchematron createSCH(@Nonnull IReadableResource iReadableResource, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.SCHEMATRON_SCH, iReadableResource), null, iIterableNamespaceContext);
    }

    @Nonnull
    public static ValidationExecutorSchematron createSchXslt(@Nonnull IReadableResource iReadableResource, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.SCHEMATRON_SCHXSLT, iReadableResource), null, iIterableNamespaceContext);
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT(@Nonnull IReadableResource iReadableResource, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        return ValidationExecutorSchematron.createXSLT(iReadableResource, null, iIterableNamespaceContext);
    }

    @Nonnull
    public static ValidationExecutorSchematron createXSLT(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.SCHEMATRON_XSLT, iReadableResource), string, iIterableNamespaceContext);
    }

    @Nonnull
    public static ValidationExecutorSchematron createOIOUBL(@Nonnull IReadableResource iReadableResource, @Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.SCHEMATRON_OIOUBL, iReadableResource), null, iIterableNamespaceContext);
    }
}

