/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.source;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillNotClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.source.ValidationSourceXMLReadableResource;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.write.XMLWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.w3c.dom.Node;

public class ValidationSourceXML
implements IValidationSourceXML {
    private final String m_sSystemID;
    private final Supplier<Node> m_aNodeFactory;
    private final boolean m_bPartialSource;
    private Node m_aNode;

    public ValidationSourceXML(@Nullable String string, @Nonnull Node node, boolean bl) {
        this(string, () -> node, bl);
        this.m_aNode = node;
    }

    public ValidationSourceXML(@Nullable String string, @Nonnull Supplier<Node> supplier, boolean bl) {
        ValueEnforcer.notNull(supplier, (String)"NodeFactory");
        this.m_sSystemID = string;
        this.m_aNodeFactory = supplier;
        this.m_bPartialSource = bl;
    }

    @Nonnull
    @Nonempty
    public String getValidationSourceTypeID() {
        return "xml";
    }

    @Nullable
    public String getSystemID() {
        return this.m_sSystemID;
    }

    @Override
    @Nullable
    public Node getNode() {
        Node node = this.m_aNode;
        if (node == null) {
            node = this.m_aNode = this.m_aNodeFactory.get();
        }
        return node;
    }

    public boolean isPartialSource() {
        return this.m_bPartialSource;
    }

    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        if (XMLWriter.writeToStream((Node)this.getNode(), (OutputStream)outputStream).isFailure()) {
            throw new IOException("Failed write XML node to OutputStream");
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SystemID", (Object)this.m_sSystemID).append("NodeFactory", this.m_aNodeFactory).append("PartialSource", this.m_bPartialSource).getToString();
    }

    @Nonnull
    public static ValidationSourceXML create(@Nullable String string, @Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return new ValidationSourceXML(string, XMLHelper.getOwnerDocument((Node)node), false);
    }

    @Nonnull
    public static ValidationSourceXML createPartial(@Nullable String string, @Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return new ValidationSourceXML(string, node, true);
    }

    @Nonnull
    public static ValidationSourceXML create(@Nonnull IReadableResource iReadableResource) {
        return new ValidationSourceXMLReadableResource(iReadableResource);
    }
}

