/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.xml.xsd;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.EValidationType;
import com.helger.phive.api.IValidationType;
import com.helger.phive.api.artefact.IValidationArtefact;
import com.helger.phive.api.artefact.ValidationArtefact;
import com.helger.phive.api.executor.AbstractValidationExecutor;
import com.helger.phive.api.result.ValidationResult;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.xml.sax.SAXParseException;

public class ValidationExecutorXSD
extends AbstractValidationExecutor<IValidationSourceXML, ValidationExecutorXSD> {
    private final Supplier<? extends Schema> m_aSchemaProvider;

    public ValidationExecutorXSD(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull Supplier<? extends Schema> supplier) {
        super(iValidationArtefact);
        ValueEnforcer.isTrue(() -> iValidationArtefact.getValidationType().getBaseType().isXSD(), (String)"Artifact is not an XSD");
        ValueEnforcer.notNull(supplier, (String)"SchemaProvider");
        this.m_aSchemaProvider = supplier;
        this.setStopValidationOnError(true);
    }

    @Nonnull
    public final Supplier<? extends Schema> getSchemaProvider() {
        return this.m_aSchemaProvider;
    }

    @Nonnull
    public ValidationResult applyValidation(@Nonnull IValidationSourceXML iValidationSourceXML, @Nullable Locale locale) {
        ValueEnforcer.notNull((Object)iValidationSourceXML, (String)"Source");
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        StopWatch stopWatch = StopWatch.createdStarted();
        Schema schema = this.m_aSchemaProvider.get();
        assert (schema != null);
        ErrorList errorList = new ErrorList();
        try {
            XMLSchemaValidationHelper.validate((Schema)schema, (Source)iValidationSourceXML.getAsTransformSource(), (ErrorList)errorList, (Locale)locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getCause() instanceof SAXParseException) {
                errorList.add((Object)AbstractSAXErrorHandler.getSaxParseError((IErrorLevel)EErrorLevel.FATAL_ERROR, (SAXParseException)((SAXParseException)illegalArgumentException.getCause())));
            }
            errorList.add((Object)((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builderFatalError().errorLocation((ILocation)new SimpleLocation(iValidationArtefact.getRuleResourcePath()))).errorText("The document to be validated is not an XML document")).linkedException((Throwable)illegalArgumentException)).build());
        }
        return this.createValidationResult((IErrorList)errorList, stopWatch.stopAndGetMillis());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ValidationExecutorXSD getClone() {
        ValidationExecutorXSD validationExecutorXSD = new ValidationExecutorXSD(this.getValidationArtefact(), this.m_aSchemaProvider);
        validationExecutorXSD.setStopValidationOnError(this.isStopValidationOnError());
        return validationExecutorXSD;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("SchemaProvider", this.m_aSchemaProvider).getToString();
    }

    @Nonnull
    public static ValidationExecutorXSD create(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XSDRes");
        return new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.XSD, iReadableResource), () -> XMLSchemaCache.getInstance().getSchema(iReadableResource));
    }

    @Nonnull
    public static ValidationExecutorXSD create(IReadableResource ... iReadableResourceArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iReadableResourceArray, (String)"XSDRes");
        return new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.XSD, (IReadableResource)ArrayHelper.getLast((Object[])iReadableResourceArray)), () -> XMLSchemaCache.getInstance().getSchema(iReadableResourceArray));
    }

    @Nonnull
    public static ValidationExecutorXSD create(@Nonnull @Nonempty List<? extends IReadableResource> list) {
        ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDRes");
        return new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact((IValidationType)EValidationType.XSD, list.get(list.size() - 1)), () -> XMLSchemaCache.getInstance().getSchema((Collection)list));
    }
}

