/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.helper.PDTFactory;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.rules.api.PhiveRulesUBLHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import jakarta.annotation.Nonnull;
import java.time.LocalDate;
import java.time.Month;
import java.time.OffsetDateTime;
import java.util.List;

@Immutable
public final class PeppolValidationBisSG {
    public static final String GROUP_ID = "eu.peppol.bis3.sg.ubl";
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_2023_7 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3.sg.ubl", (String)"invoice", (String)"2023.7");
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_2023_7 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3.sg.ubl", (String)"creditnote", (String)"2023.7");
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_2023_12 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3.sg.ubl", (String)"invoice", (String)"2023.12");
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_2023_12 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3.sg.ubl", (String)"creditnote", (String)"2023.12");
    public static final LocalDate VALID_PER_2024_12 = PDTFactory.createLocalDate((int)2025, (Month)Month.MARCH, (int)3);
    public static final OffsetDateTime VALID_PER_UTC_2014_12 = PDTFactory.createOffsetDateTimeUTC((LocalDate)VALID_PER_2024_12);
    public static final DVRCoordinate VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_2024_12 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3.sg.ubl", (String)"invoice", (String)"2024.12");
    public static final DVRCoordinate VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_2024_12 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3.sg.ubl", (String)"creditnote", (String)"2024.12");

    private PeppolValidationBisSG() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationBisSG.class.getClassLoader();
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        MapBasedNamespaceContext mapBasedNamespaceContext = PhiveRulesUBLHelper.createUBL21NSContext((String)UBL21Marshaller.invoice().getRootElementNamespaceURI());
        MapBasedNamespaceContext mapBasedNamespaceContext2 = PhiveRulesUBLHelper.createUBL21NSContext((String)UBL21Marshaller.creditNote().getRootElementNamespaceURI());
        ClassPathResource classPathResource = new ClassPathResource("external/schematron/peppol-sg/2023.7/xslt/SG-Subset-CEN-EN16931-UBL.xslt", PeppolValidationBisSG._getCL());
        ClassPathResource classPathResource2 = new ClassPathResource("external/schematron/peppol-sg/2023.7/xslt/SG-Subset-PEPPOL-EN16931-UBL.xslt", PeppolValidationBisSG._getCL());
        ClassPathResource classPathResource3 = new ClassPathResource("external/schematron/peppol-sg/2023.7/xslt/SG-Billing3-UBL.xslt", PeppolValidationBisSG._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_2023_7, (String)"SG Peppol BIS3 Invoice (UBL) 2023.7 (aka BIS 3.0.11)", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource3, (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_2023_7, (String)"SG Peppol BIS3 Credit Note (UBL) 2023.7 (aka BIS 3.0.11)", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource3, (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
        classPathResource = new ClassPathResource("external/schematron/peppol-sg/2023.12/xslt/SG-Subset-CEN-EN16931-UBL.xslt", PeppolValidationBisSG._getCL());
        classPathResource2 = new ClassPathResource("external/schematron/peppol-sg/2023.12/xslt/SG-Subset-PEPPOL-EN16931-UBL.xslt", PeppolValidationBisSG._getCL());
        classPathResource3 = new ClassPathResource("external/schematron/peppol-sg/2023.12/xslt/SG-Billing3-UBL.xslt", PeppolValidationBisSG._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_2023_12, (String)"SG Peppol BIS3 Invoice (UBL) 2023.12 (aka BIS 3.0.12)", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource3, (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_2023_12, (String)"SG Peppol BIS3 Credit Note (UBL) 2023.12 (aka BIS 3.0.12)", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource3, (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
        classPathResource = new ClassPathResource("external/schematron/peppol-sg/2024.12/xslt/SG-Subset-CEN-EN16931-UBL.xslt", PeppolValidationBisSG._getCL());
        classPathResource2 = new ClassPathResource("external/schematron/peppol-sg/2024.12/xslt/SG-Subset-PEPPOL-EN16931-UBL.xslt", PeppolValidationBisSG._getCL());
        classPathResource3 = new ClassPathResource("external/schematron/peppol-sg/2024.12/xslt/SG-Billing3-UBL.xslt", PeppolValidationBisSG._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_2024_12, (String)"SG Peppol BIS3 Invoice (UBL) 2024.12 (aka BIS 3.0.14)", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC_2014_12), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource3, (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_2024_12, (String)"SG Peppol BIS3 Credit Note (UBL) 2024.12 (aka BIS 3.0.14)", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC_2014_12), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)classPathResource3, (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
    }
}

