/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object;

import com.helger.annotation.Nonempty;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.type.ObjectType;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.tenancy.AbstractBusinessObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Map;

public final class StubObject
extends AbstractBusinessObject {
    public static final ObjectType OT_STUB = new ObjectType("stub-object");

    public StubObject(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        this(string, PDTFactory.getCurrentLocalDateTime(), string2, null, null, null, null, map);
    }

    public StubObject(@Nonnull @Nonempty String string, @Nullable LocalDateTime localDateTime, @Nullable String string2, @Nullable LocalDateTime localDateTime2, @Nullable String string3, @Nullable LocalDateTime localDateTime3, @Nullable String string4, @Nullable Map<String, String> map) {
        super(string, localDateTime, string2, localDateTime2, string3, localDateTime3, string4, map);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT_STUB;
    }

    @Nonnull
    public static StubObject createForCurrentUser() {
        return StubObject.createForUser(LoggedInUserManager.getInstance().getCurrentUserID());
    }

    @Nonnull
    public static StubObject createForCurrentUser(@Nullable Map<String, String> map) {
        return StubObject.createForUser(LoggedInUserManager.getInstance().getCurrentUserID(), map);
    }

    @Nonnull
    public static StubObject createForUser(@Nullable String string) {
        return new StubObject(GlobalIDFactory.getNewPersistentStringID(), string, null);
    }

    @Nonnull
    public static StubObject createForUser(@Nullable String string, @Nullable Map<String, String> map) {
        return new StubObject(GlobalIDFactory.getNewPersistentStringID(), string, map);
    }

    @Nonnull
    public static StubObject createForCurrentUserAndID(@Nonnull @Nonempty String string) {
        return new StubObject(string, LoggedInUserManager.getInstance().getCurrentUserID(), null);
    }

    @Nonnull
    public static StubObject createForCurrentUserAndID(@Nonnull @Nonempty String string, @Nullable Map<String, String> map) {
        return new StubObject(string, LoggedInUserManager.getInstance().getCurrentUserID(), map);
    }
}

