/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class PasswordConstraintMinLength
implements IPasswordConstraint {
    private static final String ATTR_MIN_LENGTH = "minlength";
    private final int m_nMinLength;

    public PasswordConstraintMinLength(@Nonnegative int n) {
        this.m_nMinLength = ValueEnforcer.isGT0((int)n, (String)"MinLength");
    }

    @Nonnegative
    public int getMinLength() {
        return this.m_nMinLength;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        return StringHelper.getLength((CharSequence)string) >= this.m_nMinLength;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MIN_LENGTH.getDisplayTextWithArgs(locale, new Object[]{this.m_nMinLength});
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MIN_LENGTH, this.m_nMinLength);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMinLength passwordConstraintMinLength = (PasswordConstraintMinLength)object;
        return this.m_nMinLength == passwordConstraintMinLength.m_nMinLength;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMinLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("minLength", this.m_nMinLength).getToString();
    }
}

