/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class PasswordConstraintMustContainSpecialChar
implements IPasswordConstraint {
    private static final String ATTR_MIN_SPECIAL = "minspecials";
    private final int m_nMinSpecials;

    public PasswordConstraintMustContainSpecialChar(@Nonnegative int n) {
        this.m_nMinSpecials = ValueEnforcer.isGT0((int)n, (String)"MinSpecials");
    }

    @Nonnegative
    public int getMinSpecials() {
        return this.m_nMinSpecials;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (Character.isLetterOrDigit(c)) continue;
                ++n;
            }
        }
        return n >= this.m_nMinSpecials;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MUST_CONTAIN_SPECIALS.getDisplayTextWithArgs(locale, new Object[]{this.m_nMinSpecials});
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MIN_SPECIAL, this.m_nMinSpecials);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMustContainSpecialChar passwordConstraintMustContainSpecialChar = (PasswordConstraintMustContainSpecialChar)object;
        return this.m_nMinSpecials == passwordConstraintMustContainSpecialChar.m_nMinSpecials;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMinSpecials).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("minSpecials", this.m_nMinSpecials).getToString();
    }
}

