/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.accesstoken;

import com.helger.annotation.Nonempty;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.revocation.RevocationStatus;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public final class AccessTokenMicroTypeConverter
implements IMicroTypeConverter<AccessToken> {
    private static final IMicroQName ATTR_TOKEN_STRING = new MicroQName("tokenstring");
    private static final IMicroQName ATTR_NOT_BEFORE = new MicroQName("notbefore");
    private static final IMicroQName ATTR_NOT_AFTER = new MicroQName("notafter");
    private static final String ELEMENT_REVOCATION = "revocation";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull AccessToken accessToken, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_TOKEN_STRING, accessToken.getTokenString());
        microElement.setAttributeWithConversion(ATTR_NOT_BEFORE, (Object)accessToken.getNotBefore());
        microElement.setAttributeWithConversion(ATTR_NOT_AFTER, (Object)accessToken.getNotAfter());
        microElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)accessToken.getRevocationStatus(), (String)string, (String)ELEMENT_REVOCATION));
        return microElement;
    }

    @Nonnull
    public AccessToken convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_TOKEN_STRING);
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_NOT_BEFORE, LocalDateTime.class);
        LocalDateTime localDateTime2 = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_NOT_AFTER, LocalDateTime.class);
        RevocationStatus revocationStatus = (RevocationStatus)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_REVOCATION), RevocationStatus.class);
        return new AccessToken(string, localDateTime, localDateTime2, revocationStatus);
    }
}

