/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.state.EChange;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.io.mgr.IPhotonManager;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserModificationCallback;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.salt.IPasswordSalt;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;

public interface IUserManager
extends IPhotonManager<IUser> {
    public void createDefaultsForTest();

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserModificationCallback> userModificationCallbacks();

    @Nullable
    public IUser createNewUser(@Nonnull @Nonempty String var1, @Nullable String var2, @Nonnull String var3, @Nullable String var4, @Nullable String var5, @Nullable String var6, @Nullable Locale var7, @Nullable Map<String, String> var8, boolean var9);

    @Nullable
    public IUser createPredefinedUser(@Nonnull @Nonempty String var1, @Nonnull @Nonempty String var2, @Nullable String var3, @Nonnull String var4, @Nullable String var5, @Nullable String var6, @Nullable String var7, @Nullable Locale var8, @Nullable Map<String, String> var9, boolean var10);

    @Nullable
    public IUser getUserOfID(@Nullable String var1);

    @Nullable
    default public IUser getActiveUserOfID(@Nullable String string) {
        IUser iUser = this.getUserOfID(string);
        return iUser == null || iUser.isDeleted() || iUser.isDisabled() ? null : iUser;
    }

    @Nullable
    public IUser getUserOfLoginName(@Nullable String var1);

    @Nullable
    public IUser getUserOfEmailAddress(@Nullable String var1);

    @Nullable
    public IUser getUserOfEmailAddressIgnoreCase(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllActiveUsers();

    @Nonnegative
    public long getActiveUserCount();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllDisabledUsers();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllNotDeletedUsers();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllDeletedUsers();

    public boolean containsAnyActiveUser();

    @Nonnull
    public EChange setUserData(@Nullable String var1, @Nonnull @Nonempty String var2, @Nullable String var3, @Nullable String var4, @Nullable String var5, @Nullable String var6, @Nullable Locale var7, @Nullable Map<String, String> var8, boolean var9);

    @Nonnull
    public EChange setUserPassword(@Nullable String var1, @Nonnull String var2);

    @Nonnull
    public EChange updateUserLastLogin(@Nullable String var1);

    @Nonnull
    public EChange updateUserLastFailedLogin(@Nullable String var1);

    @Nonnull
    public EChange deleteUser(@Nullable String var1);

    @Nonnull
    public EChange undeleteUser(@Nullable String var1);

    @Nonnull
    public EChange disableUser(@Nullable String var1);

    @Nonnull
    public EChange enableUser(@Nullable String var1);

    default public boolean areUserIDAndPasswordValid(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            return false;
        }
        IUser iUser = this.getUserOfID(string);
        if (iUser == null) {
            return false;
        }
        String string3 = iUser.getPasswordHash().getAlgorithmName();
        IPasswordSalt iPasswordSalt = iUser.getPasswordHash().getSalt();
        PasswordHash passwordHash = GlobalPasswordSettings.createUserPasswordHash(string3, iPasswordSalt, string2);
        return iUser.getPasswordHash().equals((Object)passwordHash);
    }
}

