/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.impl.triggers.SimpleTrigger;
import jakarta.annotation.Nonnull;

public class SimpleScheduleBuilder
implements IScheduleBuilder<SimpleTrigger> {
    private long m_nInterval = 0L;
    private int m_nRepeatCount = 0;
    private ITrigger.EMisfireInstruction m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY;

    protected SimpleScheduleBuilder() {
    }

    @Nonnull
    public static SimpleScheduleBuilder simpleSchedule() {
        return new SimpleScheduleBuilder();
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatMinutelyForever() {
        return SimpleScheduleBuilder.repeatMinutelyForever(1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatMinutelyForever(int n) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(n).repeatForever();
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatSecondlyForever() {
        return SimpleScheduleBuilder.repeatSecondlyForever(1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatSecondlyForever(int n) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(n).repeatForever();
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatHourlyForever() {
        return SimpleScheduleBuilder.repeatHourlyForever(1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatHourlyForever(int n) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(n).repeatForever();
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatMinutelyForTotalCount(int n) {
        return SimpleScheduleBuilder.repeatMinutelyForTotalCount(n, 1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatMinutelyForTotalCount(int n, int n2) {
        ValueEnforcer.isGT0((int)n, (String)"Count");
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(n2).withRepeatCount(n - 1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatSecondlyForTotalCount(int n) {
        return SimpleScheduleBuilder.repeatSecondlyForTotalCount(n, 1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatSecondlyForTotalCount(int n, int n2) {
        ValueEnforcer.isGT0((int)n, (String)"Count");
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(n2).withRepeatCount(n - 1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatHourlyForTotalCount(int n) {
        return SimpleScheduleBuilder.repeatHourlyForTotalCount(n, 1);
    }

    @Nonnull
    public static SimpleScheduleBuilder repeatHourlyForTotalCount(int n, int n2) {
        ValueEnforcer.isGT0((int)n, (String)"Count");
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(n2).withRepeatCount(n - 1);
    }

    @Override
    @Nonnull
    public SimpleTrigger build() {
        SimpleTrigger simpleTrigger = new SimpleTrigger();
        simpleTrigger.setRepeatInterval(this.m_nInterval);
        simpleTrigger.setRepeatCount(this.m_nRepeatCount);
        simpleTrigger.setMisfireInstruction(this.m_eMisfireInstruction);
        return simpleTrigger;
    }

    @Nonnull
    public SimpleScheduleBuilder withIntervalInMilliseconds(long l) {
        this.m_nInterval = l;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withIntervalInSeconds(int n) {
        this.m_nInterval = (long)n * 1000L;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withIntervalInMinutes(int n) {
        this.m_nInterval = (long)n * 60000L;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withIntervalInHours(int n) {
        this.m_nInterval = (long)n * 3600000L;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withRepeatCount(int n) {
        this.m_nRepeatCount = n;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder repeatForever() {
        this.m_nRepeatCount = -1;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withMisfireHandlingInstructionFireNow() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withMisfireHandlingInstructionNextWithExistingCount() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withMisfireHandlingInstructionNextWithRemainingCount() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withMisfireHandlingInstructionNowWithExistingCount() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT;
        return this;
    }

    @Nonnull
    public SimpleScheduleBuilder withMisfireHandlingInstructionNowWithRemainingCount() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT;
        return this;
    }
}

