/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.base.string.StringHelper;
import com.helger.quartz.ICalendar;
import com.helger.quartz.impl.calendar.AbstractCalendar;
import jakarta.annotation.Nonnull;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DailyCalendar
extends AbstractCalendar<DailyCalendar> {
    private static final String INVALID_HOUR_OF_DAY = "Invalid hour of day: ";
    private static final String INVALID_MINUTE = "Invalid minute: ";
    private static final String INVALID_SECOND = "Invalid second: ";
    private static final String INVALID_MILLIS = "Invalid millis: ";
    private static final String INVALID_TIME_RANGE = "Invalid time range: ";
    private static final String SEPARATOR = " - ";
    private static final long ONE_MILLIS = 1L;
    private static final char COLON = ':';
    private int m_nRangeStartingHourOfDay;
    private int m_nRangeStartingMinute;
    private int m_nRangeStartingSecond;
    private int m_nRangeStartingMillis;
    private int m_nRangeEndingHourOfDay;
    private int m_nRangeEndingMinute;
    private int m_nRangeEndingSecond;
    private int m_nRangeEndingMillis;
    private boolean m_bInvertTimeRange = false;

    public DailyCalendar(@Nonnull DailyCalendar dailyCalendar) {
        super(dailyCalendar);
        this.m_nRangeStartingHourOfDay = dailyCalendar.m_nRangeStartingHourOfDay;
        this.m_nRangeStartingMinute = dailyCalendar.m_nRangeStartingMinute;
        this.m_nRangeStartingSecond = dailyCalendar.m_nRangeStartingSecond;
        this.m_nRangeStartingMillis = dailyCalendar.m_nRangeStartingMillis;
        this.m_nRangeEndingHourOfDay = dailyCalendar.m_nRangeEndingHourOfDay;
        this.m_nRangeEndingMinute = dailyCalendar.m_nRangeEndingMinute;
        this.m_nRangeEndingSecond = dailyCalendar.m_nRangeEndingSecond;
        this.m_nRangeEndingMillis = dailyCalendar.m_nRangeEndingMillis;
        this.m_bInvertTimeRange = dailyCalendar.m_bInvertTimeRange;
    }

    public DailyCalendar(String string, String string2) {
        super(null, null);
        this.setTimeRange(string, string2);
    }

    public DailyCalendar(ICalendar iCalendar, String string, String string2) {
        super(iCalendar, null);
        this.setTimeRange(string, string2);
    }

    public DailyCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(null, null);
        this.setTimeRange(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public DailyCalendar(ICalendar iCalendar, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(iCalendar, null);
        this.setTimeRange(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public DailyCalendar(Calendar calendar, Calendar calendar2) {
        super(null, null);
        this.setTimeRange(calendar, calendar2);
    }

    public DailyCalendar(ICalendar iCalendar, Calendar calendar, Calendar calendar2) {
        super(iCalendar, null);
        this.setTimeRange(calendar, calendar2);
    }

    public DailyCalendar(long l, long l2) {
        super(null, null);
        this.setTimeRange(l, l2);
    }

    public DailyCalendar(ICalendar iCalendar, long l, long l2) {
        super(iCalendar, null);
        this.setTimeRange(l, l2);
    }

    public DailyCalendar(TimeZone timeZone, long l, long l2) {
        super(null, timeZone);
        this.setTimeRange(l, l2);
    }

    public DailyCalendar(ICalendar iCalendar, TimeZone timeZone, long l, long l2) {
        super(iCalendar, timeZone);
        this.setTimeRange(l, l2);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l)) {
            return false;
        }
        long l2 = this.getStartOfDayJavaCalendar(l).getTime().getTime();
        long l3 = this.getEndOfDayJavaCalendar(l).getTime().getTime();
        long l4 = this.getTimeRangeStartingTimeInMillis(l);
        long l5 = this.getTimeRangeEndingTimeInMillis(l);
        if (!this.m_bInvertTimeRange) {
            return l > l2 && l < l4 || l > l5 && l < l3;
        }
        return l >= l4 && l <= l5;
    }

    @Override
    public long getNextIncludedTime(long l) {
        long l2 = l + 1L;
        while (!this.isTimeIncluded(l2)) {
            if (!this.m_bInvertTimeRange) {
                if (l2 >= this.getTimeRangeStartingTimeInMillis(l2) && l2 <= this.getTimeRangeEndingTimeInMillis(l2)) {
                    l2 = this.getTimeRangeEndingTimeInMillis(l2) + 1L;
                    continue;
                }
                if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l2)) {
                    l2 = this.getBaseCalendar().getNextIncludedTime(l2);
                    continue;
                }
                ++l2;
                continue;
            }
            if (l2 < this.getTimeRangeStartingTimeInMillis(l2)) {
                l2 = this.getTimeRangeStartingTimeInMillis(l2);
                continue;
            }
            if (l2 > this.getTimeRangeEndingTimeInMillis(l2)) {
                l2 = this.getEndOfDayJavaCalendar(l2).getTime().getTime();
                ++l2;
                continue;
            }
            if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l2)) {
                l2 = this.getBaseCalendar().getNextIncludedTime(l2);
                continue;
            }
            ++l2;
        }
        return l2;
    }

    public long getTimeRangeStartingTimeInMillis(long l) {
        Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, this.m_nRangeStartingHourOfDay);
        calendar.set(12, this.m_nRangeStartingMinute);
        calendar.set(13, this.m_nRangeStartingSecond);
        calendar.set(14, this.m_nRangeStartingMillis);
        return calendar.getTime().getTime();
    }

    public long getTimeRangeEndingTimeInMillis(long l) {
        Calendar calendar = this.createJavaCalendar(l);
        calendar.set(11, this.m_nRangeEndingHourOfDay);
        calendar.set(12, this.m_nRangeEndingMinute);
        calendar.set(13, this.m_nRangeEndingSecond);
        calendar.set(14, this.m_nRangeEndingMillis);
        return calendar.getTime().getTime();
    }

    public boolean getInvertTimeRange() {
        return this.m_bInvertTimeRange;
    }

    public void setInvertTimeRange(boolean bl) {
        this.m_bInvertTimeRange = bl;
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault(Locale.Category.FORMAT));
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("base calendar: [");
        if (this.getBaseCalendar() != null) {
            stringBuilder.append(this.getBaseCalendar().toString());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("], time range: '");
        stringBuilder.append(numberFormat.format(this.m_nRangeStartingHourOfDay));
        stringBuilder.append(":");
        stringBuilder.append(numberFormat.format(this.m_nRangeStartingMinute));
        stringBuilder.append(":");
        stringBuilder.append(numberFormat.format(this.m_nRangeStartingSecond));
        stringBuilder.append(":");
        numberFormat.setMinimumIntegerDigits(3);
        stringBuilder.append(numberFormat.format(this.m_nRangeStartingMillis));
        numberFormat.setMinimumIntegerDigits(2);
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(numberFormat.format(this.m_nRangeEndingHourOfDay));
        stringBuilder.append(":");
        stringBuilder.append(numberFormat.format(this.m_nRangeEndingMinute));
        stringBuilder.append(":");
        stringBuilder.append(numberFormat.format(this.m_nRangeEndingSecond));
        stringBuilder.append(":");
        numberFormat.setMinimumIntegerDigits(3);
        stringBuilder.append(numberFormat.format(this.m_nRangeEndingMillis));
        stringBuilder.append("', inverted: " + this.m_bInvertTimeRange + "]");
        return stringBuilder.toString();
    }

    public final void setTimeRange(String string, String string2) {
        String[] stringArray = StringHelper.getExplodedArray((char)':', (String)string);
        if (stringArray.length < 2 || stringArray.length > 4) {
            throw new IllegalArgumentException("Invalid time string '" + string + "'");
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
        int n4 = stringArray.length == 4 ? Integer.parseInt(stringArray[3]) : 0;
        String[] stringArray2 = StringHelper.getExplodedArray((char)':', (String)string2);
        if (stringArray2.length < 2 || stringArray2.length > 4) {
            throw new IllegalArgumentException("Invalid time string '" + string2 + "'");
        }
        int n5 = Integer.parseInt(stringArray2[0]);
        int n6 = Integer.parseInt(stringArray2[1]);
        int n7 = stringArray2.length > 2 ? Integer.parseInt(stringArray2[2]) : 0;
        int n8 = stringArray2.length == 4 ? Integer.parseInt(stringArray2[3]) : 0;
        this.setTimeRange(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public final void setTimeRange(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        DailyCalendar._validate(n, n2, n3, n4);
        DailyCalendar._validate(n5, n6, n7, n8);
        Calendar calendar = this.createJavaCalendar();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
        Calendar calendar2 = this.createJavaCalendar();
        calendar2.set(11, n5);
        calendar2.set(12, n6);
        calendar2.set(13, n7);
        calendar2.set(14, n8);
        if (!calendar.before(calendar2)) {
            throw new IllegalArgumentException(INVALID_TIME_RANGE + n + ":" + n2 + ":" + n3 + ":" + n4 + SEPARATOR + n5 + ":" + n6 + ":" + n7 + ":" + n8);
        }
        this.m_nRangeStartingHourOfDay = n;
        this.m_nRangeStartingMinute = n2;
        this.m_nRangeStartingSecond = n3;
        this.m_nRangeStartingMillis = n4;
        this.m_nRangeEndingHourOfDay = n5;
        this.m_nRangeEndingMinute = n6;
        this.m_nRangeEndingSecond = n7;
        this.m_nRangeEndingMillis = n8;
    }

    public final void setTimeRange(Calendar calendar, Calendar calendar2) {
        this.setTimeRange(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), calendar2.get(11), calendar2.get(12), calendar2.get(13), calendar2.get(14));
    }

    public final void setTimeRange(long l, long l2) {
        this.setTimeRange(this.createJavaCalendar(l), this.createJavaCalendar(l2));
    }

    private static void _validate(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException(INVALID_HOUR_OF_DAY + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException(INVALID_MINUTE + n2);
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException(INVALID_SECOND + n3);
        }
        if (n4 < 0 || n4 > 999) {
            throw new IllegalArgumentException(INVALID_MILLIS + n4);
        }
    }

    @Override
    @Nonnull
    public DailyCalendar getClone() {
        return new DailyCalendar(this);
    }
}

