/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.listeners;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import jakarta.annotation.Nonnull;
import java.util.List;

public class BroadcastJobListener
implements IJobListener {
    private final String m_sName;
    private final ICommonsList<IJobListener> m_aListeners = new CommonsArrayList();

    public BroadcastJobListener(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Listener Name");
        this.m_sName = string;
    }

    public BroadcastJobListener(@Nonnull String string, List<IJobListener> list) {
        this(string);
        this.m_aListeners.addAll(list);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public void addListener(IJobListener iJobListener) {
        this.m_aListeners.add((Object)iJobListener);
    }

    public boolean removeListener(IJobListener iJobListener) {
        return this.m_aListeners.remove((Object)iJobListener);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJobListener> getListeners() {
        return (ICommonsList)this.m_aListeners.getClone();
    }

    @Override
    public void jobToBeExecuted(IJobExecutionContext iJobExecutionContext) {
        this.m_aListeners.forEach(iJobListener -> iJobListener.jobToBeExecuted(iJobExecutionContext));
    }

    @Override
    public void jobExecutionVetoed(IJobExecutionContext iJobExecutionContext) {
        this.m_aListeners.forEach(iJobListener -> iJobListener.jobExecutionVetoed(iJobExecutionContext));
    }

    @Override
    public void jobWasExecuted(IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        this.m_aListeners.forEach(iJobListener -> iJobListener.jobWasExecuted(iJobExecutionContext, jobExecutionException));
    }
}

