/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.compare.IComparable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

@Immutable
public class Key<T>
implements IComparable<Key<T>> {
    public static final String DEFAULT_GROUP = "DEFAULT";
    private final String m_sName;
    private final String m_sGroup;

    public Key(@Nonnull String string, @Nullable String string2) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sName = string;
        this.m_sGroup = string2 != null ? string2 : DEFAULT_GROUP;
    }

    @Nonnull
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final String getGroup() {
        return this.m_sGroup;
    }

    public final String getAsString() {
        return this.getGroup() + "." + this.getName();
    }

    public String toString() {
        return this.getAsString();
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_sGroup).getHashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Key key = (Key)object;
        return this.m_sName.equals(key.m_sName) && this.m_sGroup.equals(key.m_sGroup);
    }

    public int compareTo(Key<T> key) {
        if (this.m_sGroup.equals(DEFAULT_GROUP) && !key.m_sGroup.equals(DEFAULT_GROUP)) {
            return -1;
        }
        if (!this.m_sGroup.equals(DEFAULT_GROUP) && key.m_sGroup.equals(DEFAULT_GROUP)) {
            return 1;
        }
        int n = this.m_sGroup.compareTo(key.getGroup());
        if (n == 0) {
            n = this.m_sName.compareTo(key.getName());
        }
        return n;
    }

    @Nonnull
    public static String createUniqueName(String string) {
        String string2 = UUID.randomUUID().toString();
        String string3 = UUID.nameUUIDFromBytes((string != null ? string : DEFAULT_GROUP).getBytes(StandardCharsets.ISO_8859_1)).toString();
        return string3.substring(24) + "-" + string2;
    }
}

