/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.dnsjava;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.xbill.DNS.Name;
import org.xbill.DNS.config.ResolverConfigProvider;

public class CustomServerConfigProvider
implements ResolverConfigProvider {
    private final ICommonsList<InetSocketAddress> m_aServers;

    public CustomServerConfigProvider(@Nonnull ICommonsList<InetSocketAddress> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Servers");
        this.m_aServers = (ICommonsList)iCommonsList.getClone();
    }

    public void initialize() {
    }

    @Nonnull
    public List<InetSocketAddress> servers() {
        return (List)this.m_aServers.getClone();
    }

    @Nonnull
    public List<Name> searchPaths() {
        return Collections.emptyList();
    }

    @Nonnull
    public static CustomServerConfigProvider createFromInetAddressList(@Nonnull ICommonsList<InetAddress> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Servers");
        return new CustomServerConfigProvider((ICommonsList<InetSocketAddress>)iCommonsList.getAllMapped(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, 53)));
    }
}

