/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.codec.impl.RFC3986Codec;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.string.StringHelper;
import com.helger.http.EHttpMethod;
import com.helger.network.proxy.config.HttpProxyConfig;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;

@Immutable
public final class HttpClientHelper {
    public static final Charset DEF_CONTENT_CHARSET = StandardCharsets.ISO_8859_1;
    public static final Charset DEF_PROTOCOL_CHARSET = StandardCharsets.US_ASCII;

    private HttpClientHelper() {
    }

    @Nonnull
    public static HttpUriRequestBase createRequest(@Nonnull EHttpMethod eHttpMethod, @Nonnull ISimpleURL iSimpleURL) {
        String string = iSimpleURL.getAsString();
        return HttpClientHelper.createRequest(eHttpMethod, string);
    }

    @Nonnull
    public static HttpUriRequestBase createRequest(@Nonnull EHttpMethod eHttpMethod, @Nonnull String string) {
        switch (eHttpMethod) {
            case DELETE: {
                return new HttpDelete(string);
            }
            case GET: {
                return new HttpGet(string);
            }
            case HEAD: {
                return new HttpHead(string);
            }
            case OPTIONS: {
                return new HttpOptions(string);
            }
            case TRACE: {
                return new HttpTrace(string);
            }
            case PATCH: {
                return new HttpPatch(string);
            }
            case POST: {
                return new HttpPost(string);
            }
            case PUT: {
                return new HttpPut(string);
            }
        }
        throw new IllegalStateException("Unsupported HTTP method: " + String.valueOf(eHttpMethod));
    }

    @Nullable
    public static ContentType createContentType(@Nullable String string, @Nullable Charset charset) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return ContentType.create((String)string, (Charset)charset);
    }

    @Nonnull
    public static Charset getCharset(@Nonnull ContentType contentType) {
        return HttpClientHelper.getCharset(contentType, DEF_CONTENT_CHARSET);
    }

    @Nullable
    public static Charset getCharset(@Nonnull ContentType contentType, @Nullable Charset charset) {
        Charset charset2 = contentType.getCharset();
        return charset2 != null ? charset2 : charset;
    }

    @Nullable
    public static HttpHost createHttpHost(@Nullable Proxy proxy) {
        if (proxy != null && proxy.type() == Proxy.Type.HTTP && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            return new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        return null;
    }

    @Nullable
    public static HttpHost createHttpHost(@Nullable HttpProxyConfig httpProxyConfig) {
        if (httpProxyConfig != null) {
            return new HttpHost(httpProxyConfig.getHost(), httpProxyConfig.getPort());
        }
        return null;
    }

    @Nullable
    public static Credentials createCredentials(@Nullable HttpProxyConfig httpProxyConfig) {
        if (httpProxyConfig != null && httpProxyConfig.hasUserNameOrPassword()) {
            return new UsernamePasswordCredentials(httpProxyConfig.getUserName(), httpProxyConfig.getPasswordAsCharArray());
        }
        return null;
    }

    @Nullable
    public static HttpEntity createParameterEntity(@Nullable Map<String, String> map, @Nonnull ContentType contentType) {
        return HttpClientHelper.createParameterEntity(map, contentType, StandardCharsets.UTF_8);
    }

    @Nullable
    public static HttpEntity createParameterEntity(@Nullable Map<String, String> map, @Nonnull ContentType contentType, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)contentType, (String)"ContentType");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        if (map == null || map.isEmpty()) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(1024);){
            RFC3986Codec rFC3986Codec = new RFC3986Codec();
            boolean bl = true;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    nonBlockingByteArrayOutputStream.write(38);
                }
                String string = entry.getKey();
                rFC3986Codec.encode(string.getBytes(charset), (OutputStream)nonBlockingByteArrayOutputStream);
                String string2 = entry.getValue();
                if (!StringHelper.isNotEmpty((String)string2)) continue;
                nonBlockingByteArrayOutputStream.write(61);
                rFC3986Codec.encode(string2.getBytes(charset), (OutputStream)nonBlockingByteArrayOutputStream);
            }
            InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)nonBlockingByteArrayOutputStream.getAsInputStream(), contentType);
            return inputStreamEntity;
        }
    }

    @Nullable
    public static ContentType getContentType(@Nullable HttpEntity httpEntity) throws UnsupportedCharsetException {
        if (httpEntity == null) {
            return null;
        }
        return ContentType.parse((CharSequence)httpEntity.getContentType());
    }

    @Nullable
    public static ContentType getContentTypeOrDefault(@Nullable HttpEntity httpEntity) throws UnsupportedCharsetException {
        return HttpClientHelper.getContentTypeOrDefault(httpEntity, ContentType.DEFAULT_TEXT);
    }

    @Nullable
    public static ContentType getContentTypeOrDefault(@Nullable HttpEntity httpEntity, @Nullable ContentType contentType) throws UnsupportedCharsetException {
        ContentType contentType2 = HttpClientHelper.getContentType(httpEntity);
        return contentType2 != null ? contentType2 : contentType;
    }

    @Nullable
    public static String entityToString(@Nonnull HttpEntity httpEntity, @Nonnull Charset charset) throws IOException {
        byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
        return byArray == null ? null : new String(byArray, charset);
    }
}

