/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.security.HostnameVerifierVerifyAll;
import com.helger.http.security.TrustManagerTrustAll;
import com.helger.http.tls.ETLSVersion;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.http.tls.TLSConfigurationMode;
import com.helger.httpclient.HttpProxySettings;
import com.helger.httpclient.IHttpClientSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.GeneralSecurityException;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@NotThreadSafe
public class HttpClientSettings
implements IHttpClientSettings,
ICloneable<HttpClientSettings> {
    public static final ITLSConfigurationMode DEFAULT_TLS_CONFIG_MODE = new TLSConfigurationMode(new ETLSVersion[]{ETLSVersion.TLS_13, ETLSVersion.TLS_12, ETLSVersion.TLS_11, ETLSVersion.TLS_10}, CGlobal.EMPTY_STRING_ARRAY);
    public static final boolean DEFAULT_USE_SYSTEM_PROPERTIES = false;
    public static final boolean DEFAULT_USE_DNS_CACHE = true;
    public static final int DEFAULT_RETRY_COUNT = 0;
    public static final Duration DEFAULT_RETRY_INTERVAL = Duration.ofSeconds(1L);
    public static final boolean DEFAULT_RETRY_ALWAYS = false;
    public static final Timeout DEFAULT_CONNECTION_REQUEST_TIMEOUT = Timeout.ofSeconds((long)5L);
    public static final Timeout DEFAULT_CONNECT_TIMEOUT = Timeout.ofSeconds((long)5L);
    public static final Timeout DEFAULT_RESPONSE_TIMEOUT = Timeout.ofSeconds((long)10L);
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    public static final boolean DEFAULT_USE_KEEP_ALIVE = true;
    public static final boolean DEFAULT_PROTOCOL_UPGRADE_ENABLED = true;
    private final boolean m_bUseSystemProperties = false;
    private boolean m_bUseDNSClientCache = true;
    private SSLContext m_aSSLContext;
    private ITLSConfigurationMode m_aTLSConfigurationMode;
    private HostnameVerifier m_aHostnameVerifier;
    private final HttpProxySettings m_aGeneralProxy = new HttpProxySettings();
    private final HttpProxySettings m_aHttpProxy = new HttpProxySettings();
    private final HttpProxySettings m_aHttpsProxy = new HttpProxySettings();
    private int m_nRetryCount = 0;
    private Duration m_aRetryInterval = DEFAULT_RETRY_INTERVAL;
    private boolean m_bRetryAlways = false;
    private Timeout m_aConnectionRequestTimeout = DEFAULT_CONNECTION_REQUEST_TIMEOUT;
    private Timeout m_aConnectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private Timeout m_aResponseTimeout = DEFAULT_RESPONSE_TIMEOUT;
    private String m_sUserAgent;
    private boolean m_bFollowRedirects = true;
    private boolean m_bUseKeepAlive = true;
    private boolean m_bProtocolUpgradeEnabled = true;

    public HttpClientSettings() {
    }

    public HttpClientSettings(@Nonnull IHttpClientSettings iHttpClientSettings) {
        this.setAllFrom(iHttpClientSettings);
    }

    @Nonnull
    public final HttpClientSettings setAllFrom(@Nonnull IHttpClientSettings iHttpClientSettings) {
        ValueEnforcer.notNull((Object)iHttpClientSettings, (String)"Source");
        this.setUseDNSClientCache(iHttpClientSettings.isUseDNSClientCache());
        this.setSSLContext(iHttpClientSettings.getSSLContext());
        this.setTLSConfigurationMode(iHttpClientSettings.getTLSConfigurationMode());
        this.setHostnameVerifier(iHttpClientSettings.getHostnameVerifier());
        this.getGeneralProxy().setAllFrom(iHttpClientSettings.getGeneralProxy());
        this.getHttpProxy().setAllFrom(iHttpClientSettings.getHttpProxy());
        this.getHttpsProxy().setAllFrom(iHttpClientSettings.getHttpsProxy());
        this.setRetryCount(iHttpClientSettings.getRetryCount());
        this.setRetryInterval(iHttpClientSettings.getRetryInterval());
        this.setRetryAlways(iHttpClientSettings.isRetryAlways());
        this.setConnectionRequestTimeout(iHttpClientSettings.getConnectionRequestTimeout());
        this.setConnectTimeout(iHttpClientSettings.getConnectTimeout());
        this.setResponseTimeout(iHttpClientSettings.getResponseTimeout());
        this.setUserAgent(iHttpClientSettings.getUserAgent());
        this.setFollowRedirects(iHttpClientSettings.isFollowRedirects());
        this.setUseKeepAlive(iHttpClientSettings.isUseKeepAlive());
        this.setProtocolUpgradeEnabled(iHttpClientSettings.isProtocolUpgradeEnabled());
        return this;
    }

    @Override
    public final boolean isUseDNSClientCache() {
        return this.m_bUseDNSClientCache;
    }

    @Nonnull
    public final HttpClientSettings setUseDNSClientCache(boolean bl) {
        this.m_bUseDNSClientCache = bl;
        return this;
    }

    @Override
    @Nullable
    public final SSLContext getSSLContext() {
        return this.m_aSSLContext;
    }

    @Nonnull
    public final HttpClientSettings setSSLContext(@Nullable SSLContext sSLContext) {
        this.m_aSSLContext = sSLContext;
        return this;
    }

    @Nonnull
    public final HttpClientSettings setSSLContextTrustAll() throws GeneralSecurityException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{new TrustManagerTrustAll(false)}, null);
        return this.setSSLContext(sSLContext);
    }

    @Override
    @Nullable
    public final HostnameVerifier getHostnameVerifier() {
        return this.m_aHostnameVerifier;
    }

    @Nonnull
    public final HttpClientSettings setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.m_aHostnameVerifier = hostnameVerifier;
        return this;
    }

    @Nonnull
    public final HttpClientSettings setHostnameVerifierVerifyAll() {
        return this.setHostnameVerifier((HostnameVerifier)new HostnameVerifierVerifyAll(false));
    }

    @Override
    @Nullable
    public final ITLSConfigurationMode getTLSConfigurationMode() {
        return this.m_aTLSConfigurationMode;
    }

    @Nonnull
    public final HttpClientSettings setTLSConfigurationMode(@Nullable ITLSConfigurationMode iTLSConfigurationMode) {
        this.m_aTLSConfigurationMode = iTLSConfigurationMode;
        return this;
    }

    @Override
    @Nonnull
    public final HttpProxySettings getGeneralProxy() {
        return this.m_aGeneralProxy;
    }

    @Override
    @Nonnull
    public final HttpProxySettings getHttpProxy() {
        return this.m_aHttpProxy;
    }

    @Override
    @Nonnull
    public final HttpProxySettings getHttpsProxy() {
        return this.m_aHttpsProxy;
    }

    @Override
    @Nonnegative
    public final int getRetryCount() {
        return this.m_nRetryCount;
    }

    @Nonnull
    public final HttpClientSettings setRetryCount(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Retries");
        this.m_nRetryCount = n;
        return this;
    }

    @Override
    @Nonnull
    public final Duration getRetryInterval() {
        return this.m_aRetryInterval;
    }

    @Nonnull
    public final TimeValue getRetryIntervalAsTimeValue() {
        return TimeValue.ofMilliseconds((long)this.m_aRetryInterval.toMillis());
    }

    @Nonnull
    public final HttpClientSettings setRetryInterval(@Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"RetryInterval");
        this.m_aRetryInterval = duration;
        return this;
    }

    @Override
    public final boolean isRetryAlways() {
        return this.m_bRetryAlways;
    }

    @Nonnull
    public final HttpClientSettings setRetryAlways(boolean bl) {
        this.m_bRetryAlways = bl;
        return this;
    }

    @Override
    @Nonnull
    public final Timeout getConnectionRequestTimeout() {
        return this.m_aConnectionRequestTimeout;
    }

    @Nonnull
    public final HttpClientSettings setConnectionRequestTimeout(@Nonnull Timeout timeout) {
        ValueEnforcer.notNull((Object)timeout, (String)"ConnectionRequestTimeout");
        this.m_aConnectionRequestTimeout = timeout;
        return this;
    }

    @Override
    @Nonnull
    public final Timeout getConnectTimeout() {
        return this.m_aConnectTimeout;
    }

    @Nonnull
    public final HttpClientSettings setConnectTimeout(@Nonnull Timeout timeout) {
        ValueEnforcer.notNull((Object)timeout, (String)"ConnectTimeout");
        this.m_aConnectTimeout = timeout;
        return this;
    }

    @Override
    @Nonnull
    public final Timeout getResponseTimeout() {
        return this.m_aResponseTimeout;
    }

    @Nonnull
    public final HttpClientSettings setResponseTimeout(@Nonnull Timeout timeout) {
        ValueEnforcer.notNull((Object)timeout, (String)"SocketTimeout");
        this.m_aResponseTimeout = timeout;
        return this;
    }

    @Override
    @Nullable
    public final String getUserAgent() {
        return this.m_sUserAgent;
    }

    @Nonnull
    public final HttpClientSettings setUserAgent(@Nullable String string) {
        this.m_sUserAgent = string;
        return this;
    }

    @Override
    public final boolean isFollowRedirects() {
        return this.m_bFollowRedirects;
    }

    @Nonnull
    public final HttpClientSettings setFollowRedirects(boolean bl) {
        this.m_bFollowRedirects = bl;
        return this;
    }

    @Override
    public final boolean isUseKeepAlive() {
        return this.m_bUseKeepAlive;
    }

    @Nonnull
    public final HttpClientSettings setUseKeepAlive(boolean bl) {
        this.m_bUseKeepAlive = bl;
        return this;
    }

    @Override
    public final boolean isProtocolUpgradeEnabled() {
        return this.m_bProtocolUpgradeEnabled;
    }

    @Nonnull
    public final HttpClientSettings setProtocolUpgradeEnabled(boolean bl) {
        this.m_bProtocolUpgradeEnabled = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpClientSettings getClone() {
        return new HttpClientSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("UseSystemProperties", false).append("UseDNSClientCache", this.m_bUseDNSClientCache).append("SSLContext", (Object)this.m_aSSLContext).append("TLSConfigurationMode", (Object)this.m_aTLSConfigurationMode).append("HostnameVerifier", (Object)this.m_aHostnameVerifier).append("GeneralProxy", (Object)this.m_aGeneralProxy).append("HttpProxy", (Object)this.m_aHttpProxy).append("HttpsProxy", (Object)this.m_aHttpsProxy).append("RetryCount", this.m_nRetryCount).append("RetryInterval", (Object)this.m_aRetryInterval).append("RetryAlways", this.m_bRetryAlways).append("ConnectionRequestTimeout", (Object)this.m_aConnectionRequestTimeout).append("ConnectionTimeout", (Object)this.m_aConnectTimeout).append("ResponseTimeout", (Object)this.m_aResponseTimeout).append("UserAgent", (Object)this.m_sUserAgent).append("FollowRedirects", this.m_bFollowRedirects).append("UseKeepAlive", this.m_bUseKeepAlive).append("ProtocolUpgradeEnabled", this.m_bProtocolUpgradeEnabled).getToString();
    }
}

