/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.httpclient.HttpClientSettings;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.function.Function;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientSettingsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientSettingsConfig.class);

    private HttpClientSettingsConfig() {
    }

    public static final void assignConfigValues(@Nonnull HttpClientSettings httpClientSettings, @Nonnull IConfigWithFallback iConfigWithFallback, String ... stringArray) {
        ETriState eTriState;
        Object object;
        Duration duration;
        int n;
        String string2;
        UsernamePasswordCredentials usernamePasswordCredentials;
        ValueEnforcer.notNull((Object)httpClientSettings, (String)"HttpClientSettings");
        ValueEnforcer.notNull((Object)iConfigWithFallback, (String)"Config");
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"Prefixes");
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet((Object[])stringArray, string -> string.isEmpty() || string.endsWith(".") ? string : string + ".");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using prefixes '" + String.valueOf(commonsLinkedHashSet) + "' to configure HTTP client settings");
        }
        if (commonsLinkedHashSet.isEmpty()) {
            LOGGER.warn("No configuration prefixes provided to configure HTTP client settings. Nothing happens");
            return;
        }
        HttpClientConfig httpClientConfig = new HttpClientConfig(iConfigWithFallback, (ICommonsOrderedSet<String>)commonsLinkedHashSet);
        ETriState eTriState2 = httpClientConfig.getUseDNSClientCache(httpClientSettings.isUseDNSClientCache());
        if (eTriState2.isDefined()) {
            boolean bl = eTriState2.getAsBooleanValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.useDNSClientCache(" + bl + ")");
            }
            httpClientSettings.setUseDNSClientCache(bl);
        }
        if ((eTriState2 = httpClientConfig.getHttpProxyEnabled(false)).isDefined() && eTriState2.getAsBooleanValue()) {
            HttpHost httpHost = httpClientConfig.getHttpProxyObject();
            if (httpHost != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Setting configured HttpClientSettings.proxyHost(" + String.valueOf(httpHost) + ")");
                }
                httpClientSettings.getGeneralProxy().setProxyHost(httpHost);
            }
            if ((usernamePasswordCredentials = httpClientConfig.getHttpProxyCredentials()) != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Setting configured HttpClientSettings.proxyCredentials(" + String.valueOf(usernamePasswordCredentials) + ")");
                }
                httpClientSettings.getGeneralProxy().setProxyCredentials((Credentials)usernamePasswordCredentials);
            }
            if (StringHelper.isNotEmpty((String)(string2 = httpClientConfig.getNonProxyHosts()))) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Setting configured HttpClientSettings.nonProxyHosts(" + string2 + ")");
                }
                httpClientSettings.getGeneralProxy().setNonProxyHostsFromPipeString(string2);
            }
        }
        if ((n = httpClientConfig.getRetryCount()) >= 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.retryCount(" + n + ")");
            }
            httpClientSettings.setRetryCount(n);
        }
        if ((duration = httpClientConfig.getRetryInterval()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.retryInterval(" + String.valueOf(duration) + ")");
            }
            httpClientSettings.setRetryInterval(duration);
        }
        if ((usernamePasswordCredentials = httpClientConfig.getRetryAlways(httpClientSettings.isRetryAlways())).isDefined()) {
            boolean bl = usernamePasswordCredentials.getAsBooleanValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.retryAlways(" + bl + ")");
            }
            httpClientSettings.setRetryAlways(bl);
        }
        if ((object = httpClientConfig.getConnectionRequestTimeout()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.connectionRequestTimeout(" + String.valueOf(object) + ")");
            }
            httpClientSettings.setConnectionRequestTimeout((Timeout)object);
        }
        if ((duration = httpClientConfig.getConnectTimeout()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.connectTimeout(" + String.valueOf(duration) + ")");
            }
            httpClientSettings.setConnectTimeout((Timeout)duration);
        }
        if ((usernamePasswordCredentials = httpClientConfig.getResponseTimeout()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.responseTimeout(" + String.valueOf(usernamePasswordCredentials) + ")");
            }
            httpClientSettings.setResponseTimeout((Timeout)usernamePasswordCredentials);
        }
        if (StringHelper.isNotEmpty((String)(object = httpClientConfig.getUserAgent()))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.userAgent(" + (String)object + ")");
            }
            httpClientSettings.setUserAgent((String)object);
        }
        if ((duration = httpClientConfig.getFollowRedirects(httpClientSettings.isFollowRedirects())).isDefined()) {
            boolean bl = duration.getAsBooleanValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.followRedirects(" + bl + ")");
            }
            httpClientSettings.setFollowRedirects(bl);
        }
        if ((eTriState = httpClientConfig.getUseKeepAlive(httpClientSettings.isUseKeepAlive())).isDefined()) {
            boolean bl = eTriState.getAsBooleanValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.keepAlive(" + bl + ")");
            }
            httpClientSettings.setUseKeepAlive(bl);
        }
        if ((string2 = httpClientConfig.getProtocolUpgradeEnabled(httpClientSettings.isProtocolUpgradeEnabled())).isDefined()) {
            boolean bl = string2.getAsBooleanValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.protocolUpgradeEnabled(" + bl + ")");
            }
            httpClientSettings.setProtocolUpgradeEnabled(bl);
        }
        object = httpClientConfig.getDisableTlsChecks(false);
        duration = httpClientConfig.getDisableHostnameCheck(false);
        if (duration.isDefined() && duration.getAsBooleanValue() || object.isDefined() && object.getAsBooleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting configured HttpClientSettings.setHostnameVerifierVerifyAll()");
            }
            httpClientSettings.setHostnameVerifierVerifyAll();
            LOGGER.warn("Disabled the hostname check for SSL/TLS connections. This may be a security risk.");
        }
        if ((eTriState = httpClientConfig.getDisableCertificateCheck(false)).isDefined() && eTriState.getAsBooleanValue() || object.isDefined() && object.getAsBooleanValue()) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Setting configured HttpClientSettings.setSSLContextTrustAll()");
                }
                httpClientSettings.setSSLContextTrustAll();
                LOGGER.warn("Disabled the certificate check for SSL/TLS connections. This may be a security risk.");
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalStateException("Failed to set SSL Context for TLS connection", generalSecurityException);
            }
        }
    }

    public static final class HttpClientConfig {
        private final IConfigWithFallback m_aConfig;
        private final ICommonsOrderedSet<String> m_aConfigPrefixes;

        public HttpClientConfig(@Nonnull IConfigWithFallback iConfigWithFallback, @Nonnull @Nonempty ICommonsOrderedSet<String> iCommonsOrderedSet) {
            ValueEnforcer.notNull((Object)iConfigWithFallback, (String)"Config");
            ValueEnforcer.notEmptyNoNullValue(iCommonsOrderedSet, (String)"Prefixes");
            this.m_aConfig = iConfigWithFallback;
            this.m_aConfigPrefixes = iCommonsOrderedSet;
        }

        @Nonnull
        private static String[] _copyAndMap(@Nonnull String[] stringArray, @Nonnull Function<String, String> function) {
            String[] stringArray2 = new String[stringArray.length];
            ArrayHelper.forEach((Object[])stringArray, (string, n) -> {
                stringArray[n] = (String)function.apply((String)string);
            });
            return stringArray2;
        }

        @Nullable
        private String _findString(@Nonnull String string, String ... stringArray) {
            for (String string3 : this.m_aConfigPrefixes) {
                String string4;
                if (stringArray.length == 0) {
                    string4 = this.m_aConfig.getAsString((Object)(string3 + string));
                } else {
                    String[] stringArray2 = HttpClientConfig._copyAndMap(stringArray, string2 -> string3 + string2);
                    string4 = this.m_aConfig.getAsStringOrFallback(string3 + string, stringArray2);
                }
                if (string4 == null) continue;
                return string4;
            }
            return null;
        }

        @Nullable
        private char[] _findCharArray(@Nonnull String string, String ... stringArray) {
            for (String string3 : this.m_aConfigPrefixes) {
                char[] cArray;
                if (stringArray.length == 0) {
                    cArray = this.m_aConfig.getAsCharArray((Object)(string3 + string));
                } else {
                    String[] stringArray2 = HttpClientConfig._copyAndMap(stringArray, string2 -> string3 + string2);
                    cArray = this.m_aConfig.getAsCharArrayOrFallback(string3 + string, stringArray2);
                }
                if (cArray == null) continue;
                return cArray;
            }
            return null;
        }

        @Nonnull
        private ETriState _findBoolean(@Nonnull String string, boolean bl, String ... stringArray) {
            String string2 = this._findString(string, stringArray);
            if (string2 == null) {
                return ETriState.UNDEFINED;
            }
            return ETriState.valueOf((boolean)TypeConverter.convertToBoolean((Object)string2, (boolean)bl));
        }

        @CheckForSigned
        private int _findInt(@Nonnull String string, int n, String ... stringArray) {
            for (String string3 : this.m_aConfigPrefixes) {
                int n2;
                if (stringArray.length == 0) {
                    n2 = this.m_aConfig.getAsInt((Object)(string3 + string), n);
                } else {
                    String[] stringArray2 = HttpClientConfig._copyAndMap(stringArray, string2 -> string3 + string2);
                    n2 = this.m_aConfig.getAsIntOrFallback(string3 + string, n, n, stringArray2);
                }
                if (n2 == n) continue;
                return n2;
            }
            return n;
        }

        @CheckForSigned
        private long _findSingleLong(@Nonnull String string, @Nonnull String string3, long l, String ... stringArray) {
            if (stringArray.length == 0) {
                return this.m_aConfig.getAsLong((Object)(string + string3), l);
            }
            String[] stringArray2 = HttpClientConfig._copyAndMap(stringArray, string2 -> string + string2);
            return this.m_aConfig.getAsLongOrFallback(string + string3, l, l, stringArray2);
        }

        @CheckForSigned
        private long _findLong(@Nonnull String string, long l, String ... stringArray) {
            for (String string2 : this.m_aConfigPrefixes) {
                long l2 = this._findSingleLong(string2, string, l, stringArray);
                if (l2 == l) continue;
                return l2;
            }
            return l;
        }

        @Nonnull
        public ETriState getUseDNSClientCache(boolean bl) {
            return this._findBoolean("http.dnsclientcache.use", bl, "http.useDNSClientCache");
        }

        @Nonnull
        public ETriState getHttpProxyEnabled(boolean bl) {
            return this._findBoolean("http.proxy.enabled", bl, new String[0]);
        }

        @Nullable
        public String getHttpProxyHost() {
            return this._findString("http.proxy.host", "http.proxyHost", "http.proxy.address");
        }

        @CheckForSigned
        public int getHttpProxyPort() {
            return this._findInt("http.proxy.port", -1, "http.proxyPort");
        }

        @Nullable
        public HttpHost getHttpProxyObject() {
            String string = this.getHttpProxyHost();
            int n = this.getHttpProxyPort();
            if (string != null && n > 0) {
                return new HttpHost(string, n);
            }
            return null;
        }

        @Nullable
        public String getHttpProxyUsername() {
            return this._findString("http.proxy.username", "http.proxyUsername");
        }

        @Nullable
        public char[] getHttpProxyPasswordCharArray() {
            return this._findCharArray("http.proxy.password", "http.proxyPassword");
        }

        @Nullable
        public UsernamePasswordCredentials getHttpProxyCredentials() {
            String string = this.getHttpProxyUsername();
            char[] cArray = this.getHttpProxyPasswordCharArray();
            if (string != null && cArray != null) {
                return new UsernamePasswordCredentials(string, cArray);
            }
            return null;
        }

        @Nullable
        public String getNonProxyHosts() {
            return this._findString("http.proxy.nonProxyHosts", "http.nonProxyHosts", "http.proxy.non-proxy");
        }

        @CheckForSigned
        public int getRetryCount() {
            return this._findInt("http.retry.count", -1, new String[0]);
        }

        @Nullable
        private Duration _findDuration(@Nonnull String string2, String ... stringArray) {
            for (String string3 : this.m_aConfigPrefixes) {
                long l = this._findSingleLong(string3, string2 + ".millis", -1L, HttpClientConfig._copyAndMap(stringArray, string -> string + ".millis"));
                if (l > 0L) {
                    return Duration.ofMillis(l);
                }
                long l2 = this._findSingleLong(string3, string2 + ".seconds", -1L, HttpClientConfig._copyAndMap(stringArray, string -> string + ".seconds"));
                if (l2 > 0L) {
                    return Duration.ofSeconds(l2);
                }
                long l3 = this._findSingleLong(string3, string2 + ".minutes", -1L, HttpClientConfig._copyAndMap(stringArray, string -> string + ".minutes"));
                if (l3 > 0L) {
                    return Duration.ofMinutes(l3);
                }
                long l4 = this._findSingleLong(string3, string2 + ".hours", -1L, HttpClientConfig._copyAndMap(stringArray, string -> string + ".hours"));
                if (l4 <= 0L) continue;
                return Duration.ofHours(l4);
            }
            return null;
        }

        @Nullable
        public Duration getRetryInterval() {
            return this._findDuration("http.retry.interval", new String[0]);
        }

        @Nonnull
        public ETriState getRetryAlways(boolean bl) {
            return this._findBoolean("http.retry.always", bl, new String[0]);
        }

        @Nullable
        private Timeout _findTimeout(@Nonnull String string, String ... stringArray) {
            Duration duration = this._findDuration(string, stringArray);
            return duration == null ? null : Timeout.of((Duration)duration);
        }

        @Nullable
        public Timeout getConnectionRequestTimeout() {
            return this._findTimeout("http.timeout.connectionrequest", new String[0]);
        }

        @Nullable
        public Timeout getConnectTimeout() {
            return this._findTimeout("http.timeout.connect", "http.connection-timeout");
        }

        @Nullable
        public Timeout getResponseTimeout() {
            return this._findTimeout("http.timeout.response", "http.read-timeout");
        }

        @Nullable
        public String getUserAgent() {
            return this._findString("http.useragent", new String[0]);
        }

        @Nonnull
        public ETriState getFollowRedirects(boolean bl) {
            return this._findBoolean("http.follow-redirects", bl, new String[0]);
        }

        @Nonnull
        public ETriState getUseKeepAlive(boolean bl) {
            return this._findBoolean("http.keep-alive", bl, new String[0]);
        }

        @Nonnull
        public ETriState getProtocolUpgradeEnabled(boolean bl) {
            return this._findBoolean("http.protocol-upgrade.enabled", bl, new String[0]);
        }

        @Nonnull
        public ETriState getDisableTlsChecks(boolean bl) {
            return this._findBoolean("http.tls.checks.disabled", bl, new String[0]);
        }

        @Nonnull
        public ETriState getDisableHostnameCheck(boolean bl) {
            return this._findBoolean("http.tls.hostname-check.disabled", bl, new String[0]);
        }

        @Nonnull
        public ETriState getDisableCertificateCheck(boolean bl) {
            return this._findBoolean("http.tls.certificate-check.disabled", bl, new String[0]);
        }
    }
}

