/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EHandled;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.network.proxy.settings.IProxySettings;
import com.helger.network.proxy.settings.ProxySettingsManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySelectorProxySettingsManager
extends ProxySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySelectorProxySettingsManager.class);
    private final ProxySelector m_aFallback;

    public ProxySelectorProxySettingsManager(@Nullable ProxySelector proxySelector) {
        this.m_aFallback = proxySelector;
    }

    @Nullable
    public final ProxySelector getFallbackProxySelector() {
        return this.m_aFallback;
    }

    @Nullable
    @OverrideOnDemand
    protected List<Proxy> selectProxies(@Nonnull URI uRI) {
        ICommonsOrderedSet<IProxySettings> iCommonsOrderedSet = ProxySettingsManager.findAllProxySettings(uRI);
        if (iCommonsOrderedSet.isNotEmpty()) {
            return new CommonsArrayList(iCommonsOrderedSet, IProxySettings::getAsProxy);
        }
        if (this.m_aFallback != null) {
            return this.m_aFallback.select(uRI);
        }
        return null;
    }

    @Override
    @Nonnull
    public List<Proxy> select(@Nonnull URI uRI) {
        ValueEnforcer.notNull((Object)uRI, (String)"URI");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Selecting proxies for '" + String.valueOf(uRI) + "'");
        }
        CommonsArrayList commonsArrayList = this.selectProxies(uRI);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  For '" + String.valueOf(uRI) + "' the following proxies were selected: " + String.valueOf(commonsArrayList));
        }
        if (commonsArrayList == null || commonsArrayList.isEmpty()) {
            commonsArrayList = new CommonsArrayList((Object)Proxy.NO_PROXY);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Using no proxy for '" + String.valueOf(uRI) + "'");
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @OverrideOnDemand
    protected EHandled handleConnectFailed(@Nonnull URI uRI, @Nonnull SocketAddress socketAddress, @Nonnull IOException iOException) {
        return ProxySettingsManager.onConnectionFailed(uRI, socketAddress, iOException);
    }

    @Override
    public void connectFailed(@Nonnull URI uRI, @Nonnull SocketAddress socketAddress, @Nonnull IOException iOException) {
        ValueEnforcer.notNull((Object)uRI, (String)"URI");
        ValueEnforcer.notNull((Object)socketAddress, (String)"SockerAddr");
        ValueEnforcer.notNull((Object)iOException, (String)"Exception");
        LOGGER.info("Connection to '" + String.valueOf(uRI) + "' using proxy " + String.valueOf(socketAddress) + " failed", (Throwable)iOException);
        if (this.handleConnectFailed(uRI, socketAddress, iOException).isUnhandled() && this.m_aFallback != null) {
            this.m_aFallback.connectFailed(uRI, socketAddress, iOException);
        }
    }

    public static boolean isDefault() {
        return ProxySelector.getDefault() instanceof ProxySelectorProxySettingsManager;
    }

    public static void setAsDefault(boolean bl) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (!(proxySelector instanceof ProxySelectorProxySettingsManager)) {
            ProxySelector.setDefault(new ProxySelectorProxySettingsManager(bl ? proxySelector : null));
            LOGGER.info("Using ProxySelectorProxySettingsManager as the default ProxySelector");
        }
    }
}

