/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.cache.clazz.AnnotationUsageCache;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.helper.CollectionSort;
import com.helger.http.header.HttpHeaderMap;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.annotation.IsOffline;
import com.helger.servlet.request.RequestHelper;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class RequestLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLogger.class);
    private static final AnnotationUsageCache IS_OFFLINE_CACHE = new AnnotationUsageCache(IsOffline.class);
    private static final RequestLogger INSTANCE = new RequestLogger();

    private RequestLogger() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> getRequestFieldMap(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        if (IS_OFFLINE_CACHE.hasAnnotation((Object)httpServletRequest)) {
            commonsLinkedHashMap.put((Object)"Offline", (Object)"true");
        } else {
            try {
                commonsLinkedHashMap.put((Object)"AuthType", (Object)httpServletRequest.getAuthType());
                commonsLinkedHashMap.put((Object)"CharacterEncoding", (Object)httpServletRequest.getCharacterEncoding());
                commonsLinkedHashMap.put((Object)"ContentLength", (Object)Long.toString(RequestHelper.getContentLength(httpServletRequest)));
                commonsLinkedHashMap.put((Object)"ContentType", (Object)httpServletRequest.getContentType());
                commonsLinkedHashMap.put((Object)"ContextPath", (Object)ServletHelper.getRequestContextPath(httpServletRequest));
                commonsLinkedHashMap.put((Object)"ContextPath2", (Object)ServletContextPathHolder.getContextPathOrNull());
                commonsLinkedHashMap.put((Object)"LocalAddr", (Object)httpServletRequest.getLocalAddr());
                commonsLinkedHashMap.put((Object)"LocalName", (Object)httpServletRequest.getLocalName());
                commonsLinkedHashMap.put((Object)"LocalPort", (Object)Integer.toString(httpServletRequest.getLocalPort()));
                commonsLinkedHashMap.put((Object)"Method", (Object)ServletHelper.getRequestMethod(httpServletRequest));
                commonsLinkedHashMap.put((Object)"PathInfo", (Object)ServletHelper.getRequestPathInfo(httpServletRequest));
                commonsLinkedHashMap.put((Object)"PathInfo2", (Object)RequestHelper.getPathInfo(httpServletRequest));
                commonsLinkedHashMap.put((Object)"PathTranslated", (Object)httpServletRequest.getPathTranslated());
                commonsLinkedHashMap.put((Object)"Protocol", (Object)ServletHelper.getRequestProtocol(httpServletRequest));
                commonsLinkedHashMap.put((Object)"QueryString", (Object)ServletHelper.getRequestQueryString(httpServletRequest));
                commonsLinkedHashMap.put((Object)"RemoteAddr", (Object)httpServletRequest.getRemoteAddr());
                commonsLinkedHashMap.put((Object)"RemoteHost", (Object)httpServletRequest.getRemoteHost());
                commonsLinkedHashMap.put((Object)"RemotePort", (Object)Integer.toString(httpServletRequest.getRemotePort()));
                commonsLinkedHashMap.put((Object)"RemoteUser", (Object)httpServletRequest.getRemoteUser());
                commonsLinkedHashMap.put((Object)"RequestedSessionId", (Object)httpServletRequest.getRequestedSessionId());
                commonsLinkedHashMap.put((Object)"RequestURI", (Object)ServletHelper.getRequestRequestURI(httpServletRequest));
                commonsLinkedHashMap.put((Object)"RequestURI2", (Object)RequestHelper.getRequestURIDecoded(httpServletRequest));
                commonsLinkedHashMap.put((Object)"RequestURI3", (Object)RequestHelper.getRequestURIEncoded(httpServletRequest));
                commonsLinkedHashMap.put((Object)"RequestURL", (Object)ServletHelper.getRequestRequestURL(httpServletRequest).toString());
                commonsLinkedHashMap.put((Object)"RequestURL2", (Object)RequestHelper.getRequestURLDecoded(httpServletRequest).toString());
                commonsLinkedHashMap.put((Object)"RequestURL3", (Object)RequestHelper.getRequestURLEncoded(httpServletRequest).toString());
                commonsLinkedHashMap.put((Object)"Scheme", (Object)ServletHelper.getRequestScheme(httpServletRequest));
                commonsLinkedHashMap.put((Object)"ServerName", (Object)ServletHelper.getRequestServerName(httpServletRequest));
                commonsLinkedHashMap.put((Object)"ServerPort", (Object)Integer.toString(ServletHelper.getRequestServerPort(httpServletRequest)));
                commonsLinkedHashMap.put((Object)"ServletPath", (Object)ServletHelper.getRequestServletPath(httpServletRequest));
            }
            catch (RuntimeException runtimeException) {
                commonsLinkedHashMap.put((Object)"InternalErrorClass", (Object)runtimeException.getClass().getName());
                commonsLinkedHashMap.put((Object)"InternalErrorMessage", (Object)runtimeException.getMessage());
            }
        }
        HttpSession httpSession = ServletHelper.getRequestSession(httpServletRequest, false);
        if (httpSession != null) {
            commonsLinkedHashMap.put((Object)"SessionID", (Object)httpSession.getId());
        }
        return commonsLinkedHashMap;
    }

    public static void debugAppendRequestFields(@Nonnull Map<String, String> map, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Request:\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append("  ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
    }

    public static void debugAppendRequestHeader(@Nonnull HttpHeaderMap httpHeaderMap, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Headers:\n");
        httpHeaderMap.forEachHeaderLine(string -> stringBuilder.append("  ").append((String)string).append('\n'), true);
    }

    @Nonnull
    public static ICommonsOrderedMap<String, String> getRequestParameterMap(@Nonnull HttpServletRequest httpServletRequest) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        try {
            for (Map.Entry entry : CollectionSort.getSortedByKey((Map)httpServletRequest.getParameterMap()).entrySet()) {
                commonsLinkedHashMap.put((Object)((String)entry.getKey()), (Object)StringImplode.getImploded((String)", ", (Object[])((String[])entry.getValue())));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return commonsLinkedHashMap;
    }

    public static void debugAppendRequestParameters(@Nonnull Map<String, String> map, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Request parameters:\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append("  ").append(entry.getKey()).append(" = '").append(entry.getValue()).append("'\n");
        }
    }

    @Nonnull
    public static String getCookieValue(@Nonnull Cookie cookie) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cookie.getValue());
        if (StringHelper.isNotEmpty((String)cookie.getDomain())) {
            stringBuilder.append(" [domain=").append(cookie.getDomain()).append(']');
        }
        stringBuilder.append(" [maxage=").append(cookie.getMaxAge()).append(']');
        if (StringHelper.isNotEmpty((String)cookie.getPath())) {
            stringBuilder.append(" [path=").append(cookie.getPath()).append(']');
        }
        if (cookie.getSecure()) {
            stringBuilder.append(" [secure]");
        }
        if (cookie.isHttpOnly()) {
            stringBuilder.append(" [http-only]");
        }
        return stringBuilder.toString();
    }

    public static void debugAppendRequestCookies(@Nonnull HttpServletRequest httpServletRequest, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Cookies:\n");
        Cookie[] cookieArray = ServletHelper.getRequestCookies(httpServletRequest);
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                stringBuilder.append("  ").append(cookie.getName()).append(" = ").append(RequestLogger.getCookieValue(cookie)).append('\n');
            }
        }
    }

    @Nonnull
    public static StringBuilder getRequestDebugString(@Nonnull HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        RequestLogger.debugAppendRequestFields(RequestLogger.getRequestFieldMap(httpServletRequest), stringBuilder);
        RequestLogger.debugAppendRequestHeader(RequestHelper.getRequestHeaderMap(httpServletRequest), stringBuilder);
        RequestLogger.debugAppendRequestParameters(RequestLogger.getRequestParameterMap(httpServletRequest), stringBuilder);
        RequestLogger.debugAppendRequestCookies(httpServletRequest, stringBuilder);
        return stringBuilder;
    }

    public static void logRequestComplete(@Nonnull HttpServletRequest httpServletRequest) {
        LOGGER.info(RequestLogger.getRequestDebugString(httpServletRequest).toString());
    }
}

