/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.servlet.request.RequestParamMapItem;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.function.Function;

@NotThreadSafe
public class RequestParamMap
implements IRequestParamMap {
    public static final String DEFAULT_OPEN = "[";
    public static final String DEFAULT_CLOSE = "]";
    private static String s_sOpen = "[";
    private static String s_sClose = "]";
    private final ICommonsOrderedMap<String, RequestParamMapItem> m_aMap = new CommonsLinkedHashMap();

    public RequestParamMap() {
    }

    public RequestParamMap(@Nonnull Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            RequestParamMapItem requestParamMapItem = RequestParamMapItem.create(entry.getValue());
            if (requestParamMapItem == null) continue;
            this.m_aMap.put((Object)entry.getKey(), (Object)requestParamMapItem);
        }
    }

    private static void _parseAndAddItem(@Nonnull Map<String, RequestParamMapItem> map, @Nonnull String string2, @Nullable Object object) {
        Map<String, RequestParamMapItem> map2 = map;
        String string3 = string2;
        int n = s_sOpen.length();
        while (true) {
            Object object2;
            int n2;
            if ((n2 = string3.indexOf(s_sOpen)) == -1) {
                object2 = RequestParamMapItem.create(object);
                if (object2 == null) break;
                map2.put(string3, (RequestParamMapItem)object2);
                break;
            }
            if (n2 == 0) {
                string3 = string3.substring(n);
                continue;
            }
            object2 = string3.substring(0, n2);
            RequestParamMapItem requestParamMapItem = map2.computeIfAbsent((String)object2, string -> new RequestParamMapItem());
            map2 = requestParamMapItem.directGetChildren();
            string3 = string3.substring(n2 + n);
        }
    }

    public void put(@Nonnull String string, @Nullable Object object) {
        String string2 = StringReplace.replaceAll((String)string, (String)(s_sClose + s_sOpen), (CharSequence)s_sOpen);
        string2 = StringHelper.trimEnd((String)string2, (String)s_sClose);
        string2 = StringHelper.trimEndRepeatedly((String)string2, (String)s_sOpen);
        RequestParamMap._parseAndAddItem(this.m_aMap, string2, object);
    }

    @Nullable
    private static ICommonsOrderedMap<String, RequestParamMapItem> _getChildMap(@Nonnull Map<String, RequestParamMapItem> map, @Nullable String string) {
        RequestParamMapItem requestParamMapItem = map.get(string);
        return requestParamMapItem == null ? null : requestParamMapItem.directGetChildren();
    }

    @Nullable
    private ICommonsOrderedMap<String, RequestParamMapItem> _getChildMapExceptLast(String ... stringArray) {
        ValueEnforcer.notEmpty((Object[])stringArray, (String)"Path");
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this.m_aMap;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if ((iCommonsOrderedMap = RequestParamMap._getChildMap(iCommonsOrderedMap, stringArray[i])) != null) continue;
            return null;
        }
        return iCommonsOrderedMap;
    }

    @Override
    public boolean contains(String ... stringArray) {
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this._getChildMapExceptLast(stringArray);
        if (iCommonsOrderedMap == null) {
            return false;
        }
        String string = (String)ArrayHelper.getLast((Object[])stringArray);
        if (iCommonsOrderedMap.containsKey((Object)string)) {
            return true;
        }
        for (RequestParamMapItem requestParamMapItem : iCommonsOrderedMap.values()) {
            if (!requestParamMapItem.containsChild(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public RequestParamMapItem getObject(String ... stringArray) {
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this._getChildMapExceptLast(stringArray);
        return iCommonsOrderedMap == null ? null : (RequestParamMapItem)iCommonsOrderedMap.get(ArrayHelper.getLast((Object[])stringArray));
    }

    @Nullable
    private ICommonsOrderedMap<String, RequestParamMapItem> _getChildMapFully(String ... stringArray) {
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this.m_aMap;
        for (String string : stringArray) {
            if ((iCommonsOrderedMap = RequestParamMap._getChildMap(iCommonsOrderedMap, string)) != null) continue;
            return null;
        }
        return iCommonsOrderedMap;
    }

    @Override
    @Nullable
    public ICommonsOrderedMap<String, String> getValueMap(String ... stringArray) {
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this._getChildMapFully(stringArray);
        if (iCommonsOrderedMap == null) {
            return null;
        }
        return RequestParamMap.getAsValueMap(iCommonsOrderedMap);
    }

    @Override
    @Nullable
    public ICommonsOrderedMap<String, String> getValueTrimmedMap(String ... stringArray) {
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this._getChildMapFully(stringArray);
        if (iCommonsOrderedMap == null) {
            return null;
        }
        return RequestParamMap.getAsValueTrimmedMap(iCommonsOrderedMap);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public IRequestParamMap getMap(String ... stringArray) {
        ValueEnforcer.notEmpty((Object[])stringArray, (String)"Path");
        ICommonsOrderedMap<String, RequestParamMapItem> iCommonsOrderedMap = this._getChildMapFully(stringArray);
        if (iCommonsOrderedMap == null) {
            return null;
        }
        return new RequestParamMap((Map<String, ?>)iCommonsOrderedMap);
    }

    @Override
    public boolean containsKey(@Nullable String string) {
        return this.m_aMap.containsKey((Object)string);
    }

    public boolean isEmpty() {
        return this.m_aMap.isEmpty();
    }

    @Nonnegative
    public int size() {
        return this.m_aMap.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> keySet() {
        return this.m_aMap.copyOfKeySet();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<RequestParamMapItem> values() {
        return this.m_aMap.copyOfValues();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, RequestParamMapItem> getAsObjectMap() {
        return this.m_aMap.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> getAsValueMap(@Nonnull Map<String, ? extends RequestParamMapItem> map) {
        ValueEnforcer.notNull(map, (String)"Map");
        return new CommonsLinkedHashMap(map, Function.identity(), RequestParamMapItem::getValue);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAsValueMap() {
        return RequestParamMap.getAsValueMap(this.m_aMap);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> getAsValueTrimmedMap(@Nonnull Map<String, ? extends RequestParamMapItem> map) {
        ValueEnforcer.notNull(map, (String)"Map");
        return new CommonsLinkedHashMap(map, Function.identity(), RequestParamMapItem::getValueTrimmed);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAsValueTrimmedMap() {
        return RequestParamMap.getAsValueTrimmedMap(this.m_aMap);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RequestParamMap requestParamMap = (RequestParamMap)object;
        return this.m_aMap.equals(requestParamMap.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }

    @Nonnull
    public static IRequestParamMap create(@Nonnull Map<String, Object> map) {
        RequestParamMap requestParamMap = new RequestParamMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            requestParamMap.put(entry.getKey(), entry.getValue());
        }
        return requestParamMap;
    }

    @Nonnull
    public static IRequestParamMap createFromRequest(@Nonnull HttpServletRequest httpServletRequest) {
        RequestParamMap requestParamMap = new RequestParamMap();
        for (Map.Entry entry : httpServletRequest.getParameterMap().entrySet()) {
            if (((String[])entry.getValue()).length <= 0) continue;
            requestParamMap.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return requestParamMap;
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    @Nonempty
    public static String getFieldName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseName");
        return string;
    }

    @Nonnull
    @Nonempty
    public static String getFieldName(@Nonnull @Nonempty String string, String ... stringArray) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseName");
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                stringBuilder.append(s_sOpen).append(StringHelper.getNotNull((String)string2)).append(s_sClose);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getFieldName(@Nonnull @Nonempty String string, int ... nArray) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseName");
        StringBuilder stringBuilder = new StringBuilder(string);
        if (nArray != null) {
            for (int n : nArray) {
                stringBuilder.append(s_sOpen).append(n).append(s_sClose);
            }
        }
        return stringBuilder.toString();
    }

    public static void setSeparatorsToDefault() {
        s_sOpen = DEFAULT_OPEN;
        s_sClose = DEFAULT_CLOSE;
    }

    public static void setSeparators(char c, char c2) {
        ValueEnforcer.isFalse((c == c2 ? 1 : 0) != 0, (String)"Open and closing element may not be identical!");
        s_sOpen = Character.toString(c);
        s_sClose = Character.toString(c2);
    }

    public static void setSeparators(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Open");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Close");
        ValueEnforcer.isFalse((boolean)string.contains(string2), (String)"open may not contain close");
        ValueEnforcer.isFalse((boolean)string2.contains(string), (String)"close may not contain open");
        s_sOpen = string;
        s_sClose = string2;
    }

    @Nonnull
    @Nonempty
    public static String getOpenSeparator() {
        return s_sOpen;
    }

    @Nonnull
    @Nonempty
    public static String getCloseSeparator() {
        return s_sClose;
    }
}

