/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public final class RequestParamMapItem {
    private String m_sValue;
    private final ICommonsOrderedMap<String, RequestParamMapItem> m_aChildren = new CommonsLinkedHashMap();

    public RequestParamMapItem() {
    }

    public RequestParamMapItem(@Nonnull RequestParamMapItem requestParamMapItem) {
        this.m_sValue = requestParamMapItem.m_sValue;
        this.m_aChildren.putAll(requestParamMapItem.m_aChildren);
    }

    public boolean hasValue() {
        return this.m_sValue != null;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    @Nullable
    public String getValueTrimmed() {
        return StringHelper.trim((String)this.m_sValue);
    }

    public boolean hasChildren() {
        return this.m_aChildren.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public ICommonsOrderedMap<String, RequestParamMapItem> directGetChildren() {
        return this.m_aChildren;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, RequestParamMapItem> getAllChildren() {
        return this.m_aChildren.getClone();
    }

    public boolean containsChild(@Nullable String string) {
        return this.m_aChildren.containsKey((Object)string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RequestParamMapItem requestParamMapItem = (RequestParamMapItem)object;
        return EqualsHelper.equals((Object)this.m_sValue, (Object)requestParamMapItem.m_sValue) && this.m_aChildren.equals(requestParamMapItem.m_aChildren);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).append(this.m_aChildren).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("Value", (Object)this.m_sValue).appendIf("Children", this.m_aChildren, CollectionHelper::isNotEmpty).getToString();
    }

    @Nullable
    public static RequestParamMapItem create(@Nullable Object object) {
        if (object instanceof RequestParamMapItem) {
            return new RequestParamMapItem((RequestParamMapItem)object);
        }
        if (object instanceof String) {
            RequestParamMapItem requestParamMapItem = new RequestParamMapItem();
            requestParamMapItem.m_sValue = (String)object;
            return requestParamMapItem;
        }
        if (object instanceof Map) {
            RequestParamMapItem requestParamMapItem = new RequestParamMapItem();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                RequestParamMapItem requestParamMapItem2 = RequestParamMapItem.create(entry.getValue());
                if (requestParamMapItem2 == null) continue;
                requestParamMapItem.m_aChildren.put((Object)((String)entry.getKey()), (Object)requestParamMapItem2);
            }
            return requestParamMapItem;
        }
        return null;
    }
}

