/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.parse;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@NotThreadSafe
public class ParameterParser {
    private char[] m_aChars;
    private int m_nPos = 0;
    private int m_nLen = 0;
    private int m_nIndex1 = 0;
    private int m_nIndex2 = 0;
    private boolean m_bLowerCaseNames = false;

    private boolean _hasChar() {
        return this.m_nPos < this.m_nLen;
    }

    @Nullable
    private String _getToken(boolean bl) {
        while (this.m_nIndex1 < this.m_nIndex2 && Character.isWhitespace(this.m_aChars[this.m_nIndex1])) {
            ++this.m_nIndex1;
        }
        while (this.m_nIndex2 > this.m_nIndex1 && Character.isWhitespace(this.m_aChars[this.m_nIndex2 - 1])) {
            --this.m_nIndex2;
        }
        if (bl && this.m_nIndex2 - this.m_nIndex1 >= 2 && this.m_aChars[this.m_nIndex1] == '\"' && this.m_aChars[this.m_nIndex2 - 1] == '\"') {
            ++this.m_nIndex1;
            --this.m_nIndex2;
        }
        String string = null;
        if (this.m_nIndex2 > this.m_nIndex1) {
            string = new String(this.m_aChars, this.m_nIndex1, this.m_nIndex2 - this.m_nIndex1);
        }
        return string;
    }

    @Nullable
    private String _parseToken(char c, char c2) {
        char c3;
        this.m_nIndex1 = this.m_nPos;
        this.m_nIndex2 = this.m_nPos;
        while (this._hasChar() && (c3 = this.m_aChars[this.m_nPos]) != c && c3 != c2) {
            ++this.m_nIndex2;
            ++this.m_nPos;
        }
        return this._getToken(false);
    }

    @Nullable
    private String _parseQuotedToken(char c) {
        this.m_nIndex1 = this.m_nPos;
        this.m_nIndex2 = this.m_nPos;
        boolean bl = false;
        boolean bl2 = false;
        while (this._hasChar()) {
            char c2 = this.m_aChars[this.m_nPos];
            if (!bl && c == c2) break;
            if (!bl2 && c2 == '\"') {
                bl = !bl;
            }
            bl2 = !bl2 && c2 == '\\';
            ++this.m_nIndex2;
            ++this.m_nPos;
        }
        return this._getToken(true);
    }

    public boolean isLowerCaseNames() {
        return this.m_bLowerCaseNames;
    }

    @Nonnull
    public ParameterParser setLowerCaseNames(boolean bl) {
        this.m_bLowerCaseNames = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> parse(@Nullable String string, @Nullable char[] cArray) {
        if (ArrayHelper.isEmpty((char[])cArray)) {
            return new CommonsHashMap();
        }
        char c = cArray[0];
        if (string != null) {
            int n = string.length();
            for (char c2 : cArray) {
                int n2 = string.indexOf(c2);
                if (n2 == -1 || n2 >= n) continue;
                n = n2;
                c = c2;
            }
        }
        return this.parse(string, c);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> parse(@Nullable String string, char c) {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        if (string != null) {
            char[] cArray = string.toCharArray();
            this.m_aChars = cArray;
            this.m_nPos = 0;
            this.m_nLen = string.length();
            while (this._hasChar()) {
                String string2 = this._parseToken('=', c);
                String string3 = null;
                if (this._hasChar() && cArray[this.m_nPos] == '=') {
                    ++this.m_nPos;
                    string3 = this._parseQuotedToken(c);
                }
                if (this._hasChar() && cArray[this.m_nPos] == c) {
                    ++this.m_nPos;
                }
                if (!StringHelper.isNotEmpty((String)string2)) continue;
                if (this.m_bLowerCaseNames) {
                    string2 = string2.toLowerCase(Locale.US);
                }
                commonsHashMap.put((Object)string2, string3);
            }
        }
        return commonsHashMap;
    }
}

