/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.impl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.scope.GlobalScope;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.web.scope.IGlobalWebScope;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletContext;
import java.time.LocalDateTime;

@ThreadSafe
public class GlobalWebScope
extends GlobalScope
implements IGlobalWebScope {
    private final LocalDateTime m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
    private final ServletContext m_aSC;

    @Nonnull
    @Nonempty
    private static String _createScopeID(@Nonnull ServletContext servletContext) {
        ValueEnforcer.notNull((Object)servletContext, (String)"ServletContext");
        String string = servletContext.getServletContextName();
        if (string == null) {
            string = "ph-global-web-scope";
        }
        return string;
    }

    public GlobalWebScope(@Nonnull ServletContext servletContext) {
        super(GlobalWebScope._createScopeID(servletContext));
        this.m_aSC = servletContext;
        ServletContextPathHolder.setServletContextPath((String)servletContext.getContextPath());
    }

    @Override
    @Nonnull
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    protected void postDestroy() {
        super.postDestroy();
        ServletContextPathHolder.clearContextPath();
    }

    @Override
    @Nonnull
    public final ServletContext getServletContext() {
        return this.m_aSC;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GlobalWebScope globalWebScope = (GlobalWebScope)object;
        return this.m_aSC.getContextPath().equals(globalWebScope.getServletContext().getContextPath());
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aSC.getContextPath()).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ServletContext", (Object)this.m_aSC).getToString();
    }
}

