/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EContinue;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.servlet.response.EXFrameOptionType;
import com.helger.url.ISimpleURL;
import com.helger.xservlet.filter.IXServletLowLevelFilter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class XServletFilterSecurityXFrameOptions
implements IXServletLowLevelFilter {
    private final EXFrameOptionType m_eType;
    private final ISimpleURL m_aDomain;
    private final String m_sHeaderValue;

    public XServletFilterSecurityXFrameOptions(@Nonnull EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)eXFrameOptionType, (String)"Type");
        if (eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull((Object)iSimpleURL, (String)"Domain");
        }
        this.m_eType = eXFrameOptionType;
        this.m_aDomain = iSimpleURL;
        this.m_sHeaderValue = eXFrameOptionType.isURLRequired() ? eXFrameOptionType.getID() + " " + iSimpleURL.getAsString() : eXFrameOptionType.getID();
    }

    @Nonnull
    public final EXFrameOptionType getXFrameOptionsType() {
        return this.m_eType;
    }

    @Nullable
    public final ISimpleURL getDomain() {
        return this.m_aDomain;
    }

    @Nonnull
    @Nonempty
    public final String getHeaderValue() {
        return this.m_sHeaderValue;
    }

    @Override
    @Nonnull
    public EContinue beforeRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod) {
        httpServletResponse.addHeader("X-Frame-Options", this.m_sHeaderValue);
        return EContinue.CONTINUE;
    }
}

