/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.servletstatus;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.datetime.helper.PDTFactory;
import com.helger.xservlet.servletstatus.EServletStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ServletStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStatus.class);
    private final String m_sClassName;
    private EServletStatus m_eCurrentStatus;
    private final ICommonsMap<EServletStatus, LocalDateTime> m_aStatusChangeDates = new CommonsEnumMap(EServletStatus.class);
    private final AtomicInteger m_aInvocationCount = new AtomicInteger(0);

    public ServletStatus(@Nonnull @Nonempty String string) {
        this.m_sClassName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ClassName");
    }

    @Nonnull
    @Nonempty
    public final String getClassName() {
        return this.m_sClassName;
    }

    @Nullable
    public final EServletStatus getCurrentStatus() {
        return this.m_eCurrentStatus;
    }

    void internalSetCurrentStatus(@Nonnull EServletStatus eServletStatus) {
        ValueEnforcer.notNull((Object)((Object)eServletStatus), (String)"NewStatus");
        if (!EServletStatus.isValidSuccessorOf(this.m_eCurrentStatus, eServletStatus)) {
            LOGGER.error("The new status " + String.valueOf((Object)eServletStatus) + " is not a valid successor of the old status " + String.valueOf((Object)this.m_eCurrentStatus) + " for " + this.m_sClassName);
        }
        this.m_eCurrentStatus = (EServletStatus)((Object)ValueEnforcer.notNull((Object)((Object)eServletStatus), (String)"NewStatus"));
        this.m_aStatusChangeDates.put((Object)eServletStatus, (Object)PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<EServletStatus, LocalDateTime> getStatusChangeMap() {
        return (ICommonsMap)this.m_aStatusChangeDates.getClone();
    }

    @Nullable
    public final LocalDateTime getDateTimeOfStatus(@Nonnull EServletStatus eServletStatus) {
        return eServletStatus == null ? null : (LocalDateTime)this.m_aStatusChangeDates.get((Object)eServletStatus);
    }

    void internalIncrementInvocationCount() {
        this.m_aInvocationCount.incrementAndGet();
    }

    @Nonnegative
    public final int getInvocationCount() {
        return this.m_aInvocationCount.get();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ClassName", (Object)this.m_sClassName).append("CurrentStatus", (Enum)this.m_eCurrentStatus).append("StatusChangeDates", this.m_aStatusChangeDates).append("InvocationCount", this.m_aInvocationCount.get()).getToString();
    }
}

