/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp.ace;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.SID;
import com.hierynomus.msdtyp.ace.AceHeader;
import com.hierynomus.msdtyp.ace.AceType;
import com.hierynomus.msdtyp.ace.AceType1;
import com.hierynomus.msdtyp.ace.AceType2;
import com.hierynomus.msdtyp.ace.AceType3;
import com.hierynomus.msdtyp.ace.AceType4;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;

public abstract class ACE {
    static int HEADER_STRUCTURE_SIZE = 4;
    AceHeader aceHeader = new AceHeader();
    long accessMask;
    private SID sid = new SID();

    ACE(AceHeader aceHeader, long accessMask, SID sid) {
        this.aceHeader = aceHeader;
        this.accessMask = accessMask;
        this.sid = sid;
    }

    protected ACE() {
    }

    public final void write(SMBBuffer buffer) {
        this.aceHeader.writeTo(buffer);
        this.writeTo(buffer);
    }

    protected abstract void writeTo(SMBBuffer var1);

    public final ACE read(SMBBuffer buffer) throws Buffer.BufferException {
        this.aceHeader.readFrom(buffer);
        this.readMessage(buffer);
        return this;
    }

    public static ACE factory(SMBBuffer buffer) throws Buffer.BufferException {
        AceType aceType = EnumWithValue.EnumUtils.valueOf(buffer.readByte(), AceType.class, null);
        buffer.rpos(buffer.rpos() - 1);
        ACE ace = null;
        switch (aceType) {
            case ACCESS_ALLOWED_ACE_TYPE: {
                ace = new AceType1().read(buffer);
                break;
            }
            case ACCESS_ALLOWED_CALLBACK_ACE_TYPE: {
                ace = new AceType3().read(buffer);
                break;
            }
            case ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE: {
                ace = new AceType4().read(buffer);
                break;
            }
            case ACCESS_ALLOWED_OBJECT_ACE_TYPE: {
                ace = new AceType2().read(buffer);
                break;
            }
            case ACCESS_DENIED_ACE_TYPE: {
                ace = new AceType1().read(buffer);
                break;
            }
            case ACCESS_DENIED_CALLBACK_ACE_TYPE: {
                ace = new AceType3().read(buffer);
                break;
            }
            case ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE: {
                ace = new AceType4().read(buffer);
                break;
            }
            case ACCESS_DENIED_OBJECT_ACE_TYPE: {
                ace = new AceType2().read(buffer);
                break;
            }
            case SYSTEM_AUDIT_ACE_TYPE: {
                ace = new AceType1().read(buffer);
                break;
            }
            case SYSTEM_AUDIT_CALLBACK_ACE_TYPE: {
                ace = new AceType3().read(buffer);
                break;
            }
            case SYSTEM_AUDIT_CALLBACK_OBJECT_ACE_TYPE: {
                ace = new AceType4().read(buffer);
                break;
            }
            case SYSTEM_AUDIT_OBJECT_ACE_TYPE: {
                ace = new AceType4().read(buffer);
                break;
            }
            case SYSTEM_MANDATORY_LABEL_ACE_TYPE: {
                ace = new AceType1().read(buffer);
                break;
            }
            case SYSTEM_RESOURCE_ATTRIBUTE_ACE_TYPE: {
                ace = new AceType3().read(buffer);
                break;
            }
            case SYSTEM_SCOPED_POLICY_ID_ACE_TYPE: {
                ace = new AceType1().read(buffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ACE type: " + aceType);
            }
        }
        return ace;
    }

    public String toString() {
        return "ACE{aceHeader=" + this.aceHeader + ", accessMask=" + EnumWithValue.EnumUtils.toEnumSet(this.accessMask, AccessMask.class) + ", sid=" + this.sid + '}';
    }

    protected abstract void readMessage(SMBBuffer var1) throws Buffer.BufferException;

    public AceHeader getAceHeader() {
        return this.aceHeader;
    }

    public SID getSid() {
        return this.sid;
    }

    public long getAccessMask() {
        return this.accessMask;
    }
}

