/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.SMB2MultiCreditPacket;
import com.hierynomus.smbj.common.SMBBuffer;
import com.hierynomus.smbj.connection.NegotiatedProtocol;

public class SMB2ReadRequest
extends SMB2MultiCreditPacket {
    private final long offset;
    private final SMB2FileId fileId;

    public SMB2ReadRequest(NegotiatedProtocol negotiatedProtocol, SMB2FileId fileId, long sessionId, long treeId, long offset) {
        super(49, negotiatedProtocol.getDialect(), SMB2MessageCommandCode.SMB2_READ, sessionId, treeId, negotiatedProtocol.getMaxReadSize());
        this.fileId = fileId;
        this.offset = offset;
    }

    @Override
    protected void writeTo(SMBBuffer buffer) {
        buffer.putUInt16(this.structureSize);
        buffer.putByte((byte)0);
        buffer.putByte((byte)0);
        buffer.putUInt32(NegotiatedProtocol.SINGLE_CREDIT_PAYLOAD_SIZE * this.creditsAssigned);
        buffer.putUInt64(this.offset);
        this.fileId.write(buffer);
        buffer.putUInt32(1L);
        buffer.putUInt32(0L);
        buffer.putUInt32(0L);
        buffer.putUInt16(0);
        buffer.putUInt16(0);
        buffer.putByte((byte)0);
    }
}

