/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.messages;

import com.hierynomus.msdtyp.MsDataTypes;
import com.hierynomus.ntlm.messages.AvId;
import com.hierynomus.ntlm.messages.NtlmNegotiateFlag;
import com.hierynomus.ntlm.messages.NtlmPacket;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmChallenge
extends NtlmPacket {
    private static final Logger logger = LoggerFactory.getLogger(NtlmChallenge.class);
    private int targetNameLen;
    private int targetNameBufferOffset;
    private EnumSet<NtlmNegotiateFlag> negotiateFlags;
    private byte[] serverChallenge;
    private int targetInfoLen;
    private int targetInfoBufferOffset;
    private String targetName;
    private Map<AvId, Object> targetInfo = new HashMap<AvId, Object>();
    private byte[] rawTargetInfo;

    @Override
    public NtlmPacket read(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        buffer.readString(StandardCharsets.UTF_8, 8);
        buffer.readUInt32();
        this.readTargetNameFields(buffer);
        this.negotiateFlags = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt32(), NtlmNegotiateFlag.class);
        this.serverChallenge = buffer.readRawBytes(8);
        buffer.skip(8);
        this.readTargetInfoFields(buffer);
        this.readVersion(buffer);
        this.readTargetName(buffer);
        this.readTargetInfo(buffer);
        return this;
    }

    private void readTargetInfo(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        if (this.targetInfoLen > 0) {
            buffer.rpos(this.targetInfoBufferOffset);
            this.rawTargetInfo = buffer.readRawBytes(this.targetInfoLen);
            buffer.rpos(this.targetInfoBufferOffset);
            AvId avId = null;
            while (true) {
                int l = buffer.readUInt16();
                avId = EnumWithValue.EnumUtils.valueOf(l, AvId.class, null);
                logger.trace("NTLM channel contains {}({}) TargetInfo", (Object)avId, (Object)l);
                int avLen = buffer.readUInt16();
                switch (avId) {
                    case MsvAvEOL: {
                        return;
                    }
                    case MsvAvNbComputerName: 
                    case MsvAvNdDomainName: 
                    case MsvAvDnsComputerName: 
                    case MsvAvDnsDomainName: 
                    case MsvAvDnsTreeName: 
                    case MsvAvTargetName: {
                        this.targetInfo.put(avId, buffer.readString(StandardCharsets.UTF_16LE, avLen / 2));
                        break;
                    }
                    case MsvAvFlags: {
                        break;
                    }
                    case MsvAvTimestamp: {
                        this.targetInfo.put(avId, MsDataTypes.readFileTime(buffer));
                        break;
                    }
                    case MsvAvSingleHost: {
                        break;
                    }
                }
            }
        }
    }

    private void readTargetName(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        if (this.targetNameLen > 0) {
            buffer.rpos(this.targetNameBufferOffset);
            this.targetName = buffer.readString(StandardCharsets.UTF_16LE, this.targetNameLen / 2);
        }
    }

    private void readVersion(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        if (this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_VERSION)) {
            buffer.skip(8);
        } else {
            buffer.skip(8);
        }
    }

    private void readTargetNameFields(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        this.targetNameLen = buffer.readUInt16();
        buffer.skip(2);
        this.targetNameBufferOffset = buffer.readUInt32AsInt();
    }

    private void readTargetInfoFields(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        if (this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_TARGET_INFO)) {
            this.targetInfoLen = buffer.readUInt16();
            buffer.skip(2);
            this.targetInfoBufferOffset = buffer.readUInt32AsInt();
        } else {
            buffer.skip(8);
        }
    }

    public String getTargetName() {
        return this.targetName;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public EnumSet<NtlmNegotiateFlag> getNegotiateFlags() {
        return this.negotiateFlags;
    }

    public byte[] getTargetInfo() {
        return this.rawTargetInfo;
    }
}

