/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.protocol.commons.buffer;

import com.hierynomus.protocol.commons.buffer.Buffer;
import java.nio.charset.StandardCharsets;

public abstract class Endian {
    public static final Endian LE = new Little();
    public static final Endian BE = new Big();

    public abstract <T extends Buffer<T>> void writeUInt16(Buffer<T> var1, int var2);

    public abstract <T extends Buffer<T>> int readUInt16(Buffer<T> var1) throws Buffer.BufferException;

    public abstract <T extends Buffer<T>> void writeUInt24(Buffer<T> var1, int var2);

    public abstract <T extends Buffer<T>> int readUInt24(Buffer<T> var1) throws Buffer.BufferException;

    public abstract <T extends Buffer<T>> void writeUInt32(Buffer<T> var1, long var2);

    public abstract <T extends Buffer<T>> long readUInt32(Buffer<T> var1) throws Buffer.BufferException;

    public abstract <T extends Buffer<T>> void writeUInt64(Buffer<T> var1, long var2);

    public abstract <T extends Buffer<T>> long readUInt64(Buffer<T> var1) throws Buffer.BufferException;

    public abstract <T extends Buffer<T>> void writeLong(Buffer<T> var1, long var2);

    public abstract <T extends Buffer<T>> long readLong(Buffer<T> var1) throws Buffer.BufferException;

    public abstract <T extends Buffer<T>> void writeUtf16String(Buffer<T> var1, String var2);

    public abstract <T extends Buffer<T>> String readUtf16String(Buffer<T> var1, int var2) throws Buffer.BufferException;

    private static class Little
    extends Endian {
        private Little() {
        }

        @Override
        public <T extends Buffer<T>> void writeUInt16(Buffer<T> buffer, int uint16) {
            buffer.ensureCapacity(2);
            if (uint16 < 0 || uint16 > 65535) {
                throw new IllegalArgumentException("Invalid uint16 value: " + uint16);
            }
            buffer.data[buffer.wpos++] = (byte)uint16;
            buffer.data[buffer.wpos++] = (byte)(uint16 >> 8);
        }

        @Override
        public <T extends Buffer<T>> int readUInt16(Buffer<T> buffer) throws Buffer.BufferException {
            buffer.ensureAvailable(2);
            return buffer.data[buffer.rpos++] & 0xFF | buffer.data[buffer.rpos++] << 8 & 0xFF00;
        }

        @Override
        public <T extends Buffer<T>> void writeUInt24(Buffer<T> buffer, int uint24) {
            buffer.ensureCapacity(3);
            if (uint24 < 0 || uint24 > 0xFFFFFF) {
                throw new IllegalArgumentException("Invalid uint24 value: " + uint24);
            }
            buffer.data[buffer.wpos++] = (byte)uint24;
            buffer.data[buffer.wpos++] = (byte)(uint24 >> 8);
            buffer.data[buffer.wpos++] = (byte)(uint24 >> 16);
        }

        @Override
        public <T extends Buffer<T>> int readUInt24(Buffer<T> buffer) throws Buffer.BufferException {
            buffer.ensureAvailable(3);
            return buffer.data[buffer.rpos++] & 0xFF | buffer.data[buffer.rpos++] << 8 & 0xFF00 | buffer.data[buffer.rpos++] << 16 & 0xFF0000;
        }

        @Override
        public <T extends Buffer<T>> void writeUInt32(Buffer<T> buffer, long uint32) {
            buffer.ensureCapacity(4);
            if (uint32 < 0L || uint32 > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("Invalid uint32 value: " + uint32);
            }
            buffer.data[buffer.wpos++] = (byte)uint32;
            buffer.data[buffer.wpos++] = (byte)(uint32 >> 8);
            buffer.data[buffer.wpos++] = (byte)(uint32 >> 16);
            buffer.data[buffer.wpos++] = (byte)(uint32 >> 24);
        }

        @Override
        public <T extends Buffer<T>> long readUInt32(Buffer<T> buffer) throws Buffer.BufferException {
            buffer.ensureAvailable(4);
            return (long)buffer.data[buffer.rpos++] & 0xFFL | (long)(buffer.data[buffer.rpos++] << 8) & 0xFF00L | (long)(buffer.data[buffer.rpos++] << 16) & 0xFF0000L | (long)(buffer.data[buffer.rpos++] << 24) & 0xFF000000L;
        }

        @Override
        public <T extends Buffer<T>> void writeUInt64(Buffer<T> buffer, long uint64) {
            if (uint64 < 0L) {
                throw new IllegalArgumentException("Invalid uint64 value: " + uint64);
            }
            this.writeLong(buffer, uint64);
        }

        @Override
        public <T extends Buffer<T>> long readUInt64(Buffer<T> buffer) throws Buffer.BufferException {
            long uint64 = (this.readUInt32(buffer) & 0xFFFFFFFFL) + (this.readUInt32(buffer) << 32);
            if (uint64 < 0L) {
                throw new Buffer.BufferException("Cannot handle values > 9223372036854775807");
            }
            return uint64;
        }

        @Override
        public <T extends Buffer<T>> void writeLong(Buffer<T> buffer, long longVal) {
            buffer.ensureCapacity(8);
            buffer.data[buffer.wpos++] = (byte)longVal;
            buffer.data[buffer.wpos++] = (byte)(longVal >> 8);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 16);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 24);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 32);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 40);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 48);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 56);
        }

        @Override
        public <T extends Buffer<T>> long readLong(Buffer<T> buffer) throws Buffer.BufferException {
            long result = 0L;
            byte[] bytes = buffer.readRawBytes(8);
            for (int i = 7; i >= 0; --i) {
                result <<= 8;
                result |= (long)(bytes[i] & 0xFF);
            }
            return result;
        }

        @Override
        public <T extends Buffer<T>> String readUtf16String(Buffer<T> buffer, int length) throws Buffer.BufferException {
            byte[] stringBytes = new byte[length * 2];
            buffer.readRawBytes(stringBytes);
            return new String(stringBytes, StandardCharsets.UTF_16LE);
        }

        @Override
        public <T extends Buffer<T>> void writeUtf16String(Buffer<T> buffer, String string) {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_16LE);
            buffer.putRawBytes(bytes);
        }

        public String toString() {
            return "little endian";
        }
    }

    private static class Big
    extends Endian {
        private Big() {
        }

        @Override
        public <T extends Buffer<T>> void writeUInt16(Buffer<T> buffer, int uint16) {
            buffer.ensureCapacity(2);
            if (uint16 < 0 || uint16 > 65535) {
                throw new IllegalArgumentException("Invalid uint16 value: " + uint16);
            }
            buffer.data[buffer.wpos++] = (byte)(uint16 >> 8);
            buffer.data[buffer.wpos++] = (byte)uint16;
        }

        @Override
        public <T extends Buffer<T>> int readUInt16(Buffer<T> buffer) throws Buffer.BufferException {
            buffer.ensureAvailable(2);
            return buffer.data[buffer.rpos++] << 8 & 0xFF00 | buffer.data[buffer.rpos++] & 0xFF;
        }

        @Override
        public <T extends Buffer<T>> void writeUInt24(Buffer<T> buffer, int uint24) {
            buffer.ensureCapacity(3);
            if (uint24 < 0 || uint24 > 0xFFFFFF) {
                throw new IllegalArgumentException("Invalid uint24 value: " + uint24);
            }
            buffer.data[buffer.wpos++] = (byte)(uint24 >> 16);
            buffer.data[buffer.wpos++] = (byte)(uint24 >> 8);
            buffer.data[buffer.wpos++] = (byte)uint24;
        }

        @Override
        public <T extends Buffer<T>> int readUInt24(Buffer<T> buffer) throws Buffer.BufferException {
            buffer.ensureAvailable(3);
            return buffer.data[buffer.rpos++] << 16 & 0xFF0000 | buffer.data[buffer.rpos++] << 8 & 0xFF00 | buffer.data[buffer.rpos++] & 0xFF;
        }

        @Override
        public <T extends Buffer<T>> void writeUInt32(Buffer<T> buffer, long uint32) {
            buffer.ensureCapacity(4);
            if (uint32 < 0L || uint32 > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("Invalid uint32 value: " + uint32);
            }
            buffer.data[buffer.wpos++] = (byte)(uint32 >> 24);
            buffer.data[buffer.wpos++] = (byte)(uint32 >> 16);
            buffer.data[buffer.wpos++] = (byte)(uint32 >> 8);
            buffer.data[buffer.wpos++] = (byte)uint32;
        }

        @Override
        public <T extends Buffer<T>> long readUInt32(Buffer<T> buffer) throws Buffer.BufferException {
            buffer.ensureAvailable(4);
            return (long)(buffer.data[buffer.rpos++] << 24) & 0xFF000000L | (long)(buffer.data[buffer.rpos++] << 16) & 0xFF0000L | (long)(buffer.data[buffer.rpos++] << 8) & 0xFF00L | (long)buffer.data[buffer.rpos++] & 0xFFL;
        }

        @Override
        public <T extends Buffer<T>> void writeUInt64(Buffer<T> buffer, long uint64) {
            if (uint64 < 0L) {
                throw new IllegalArgumentException("Invalid uint64 value: " + uint64);
            }
            this.writeLong(buffer, uint64);
        }

        @Override
        public <T extends Buffer<T>> long readUInt64(Buffer<T> buffer) throws Buffer.BufferException {
            long uint64 = (this.readUInt32(buffer) << 32) + (this.readUInt32(buffer) & 0xFFFFFFFFL);
            if (uint64 < 0L) {
                throw new Buffer.BufferException("Cannot handle values > 9223372036854775807");
            }
            return uint64;
        }

        @Override
        public <T extends Buffer<T>> void writeLong(Buffer<T> buffer, long longVal) {
            buffer.ensureCapacity(8);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 56);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 48);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 40);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 32);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 24);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 16);
            buffer.data[buffer.wpos++] = (byte)(longVal >> 8);
            buffer.data[buffer.wpos++] = (byte)longVal;
        }

        @Override
        public <T extends Buffer<T>> long readLong(Buffer<T> buffer) throws Buffer.BufferException {
            long result = 0L;
            for (int i = 0; i < 8; ++i) {
                result <<= 8;
                result |= (long)(buffer.data[buffer.rpos++] & 0xFF);
            }
            return result;
        }

        @Override
        public <T extends Buffer<T>> String readUtf16String(Buffer<T> buffer, int length) throws Buffer.BufferException {
            byte[] stringBytes = new byte[length * 2];
            buffer.readRawBytes(stringBytes);
            return new String(stringBytes, StandardCharsets.UTF_16BE);
        }

        @Override
        public <T extends Buffer<T>> void writeUtf16String(Buffer<T> buffer, String string) {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_16BE);
            buffer.putRawBytes(bytes);
        }

        public String toString() {
            return "big endian";
        }
    }
}

