/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.protocol.commons.socket;

import com.hierynomus.protocol.commons.socket.ProxySocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public abstract class SocketClient {
    private final int defaultPort;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private SocketFactory socketFactory = new ProxySocketFactory();
    private int soTimeout = 0;

    public SocketClient(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public void connect(String hostname, int port) throws IOException {
        this.connect(InetAddress.getByName(hostname), port);
    }

    public void connect(InetAddress host, int port) throws IOException {
        this.socket = this.socketFactory.createSocket(host, port);
        this.onConnect();
    }

    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws IOException {
        this.socket = this.socketFactory.createSocket(host, port, localAddr, localPort);
        this.onConnect();
    }

    public void connect(String hostname, int port, InetAddress localAddr, int localPort) throws IOException {
        this.connect(InetAddress.getByName(hostname), port, localAddr, localPort);
    }

    public void connect(InetAddress host) throws IOException {
        this.connect(host, this.defaultPort);
    }

    public void connect(String hostname) throws IOException {
        this.connect(hostname, this.defaultPort);
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory == null ? new ProxySocketFactory() : factory;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected InputStream getInputStream() {
        return this.input;
    }

    protected OutputStream getOutputStream() {
        return this.output;
    }

    protected void onConnect() throws IOException {
        this.socket.setSoTimeout(this.soTimeout);
        this.input = this.socket.getInputStream();
        this.output = this.socket.getOutputStream();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public String getRemoteHostname() {
        return this.getRemoteAddress().getHostName();
    }
}

