/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.io;

import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ByteChunkProvider {
    static final int CHUNK_SIZE = 65536;
    private int offset;

    public abstract boolean isAvailable();

    public void writeChunk(OutputStream os) {
        byte[] chunk = new byte[65536];
        try {
            int size = this.getChunk(chunk);
            os.write(chunk, 0, size);
            this.offset += size;
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
    }

    public void writeChunks(Buffer<?> buffer, int nrChunks) {
        byte[] chunk = new byte[65536];
        for (int i = 0; i < nrChunks; ++i) {
            try {
                int size = this.getChunk(chunk);
                buffer.putRawBytes(chunk, 0, size);
                this.offset += size;
                continue;
            }
            catch (IOException e) {
                throw new SMBRuntimeException(e);
            }
        }
    }

    public void writeChunk(Buffer<?> buffer) {
        byte[] chunk = new byte[65536];
        try {
            int size = this.getChunk(chunk);
            buffer.putRawBytes(chunk, 0, size);
            this.offset += size;
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    protected abstract int getChunk(byte[] var1) throws IOException;

    public abstract int bytesLeft();
}

