/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileInformationClass;
import com.hierynomus.msfscc.fileinformation.FileInfo;
import com.hierynomus.msfscc.fileinformation.FileInformationFactory;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryRequest;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryResponse;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Directory
extends DiskEntry {
    private static final Logger logger = LoggerFactory.getLogger(Directory.class);

    public Directory(SMB2FileId fileId, TreeConnect treeConnect, String fileName) {
        super(treeConnect, fileId, fileName);
    }

    public List<FileInfo> list() throws TransportException, SMBApiException {
        SMB2QueryDirectoryRequest qdr;
        Session session = this.treeConnect.getSession();
        Connection connection = session.getConnection();
        Future qdFuture = connection.send(qdr = new SMB2QueryDirectoryRequest(connection.getNegotiatedProtocol().getDialect(), session.getSessionId(), this.treeConnect.getTreeId(), this.getFileId(), FileInformationClass.FileIdBothDirectoryInformation, EnumSet.of(SMB2QueryDirectoryRequest.SMB2QueryDirectoryFlags.SMB2_REOPEN), 0L, null));
        SMB2QueryDirectoryResponse qdResp = (SMB2QueryDirectoryResponse)Futures.get(qdFuture, TransportException.Wrapper);
        if (qdResp.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
            throw new SMBApiException(qdResp.getHeader(), "Query directory failed for " + this.fileName + "/" + this.fileId);
        }
        byte[] outputBuffer = qdResp.getOutputBuffer();
        try {
            return FileInformationFactory.parseFileInformationList(outputBuffer, FileInformationClass.FileIdBothDirectoryInformation);
        }
        catch (Buffer.BufferException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public SMB2FileId getFileId() {
        return this.fileId;
    }

    @Override
    public void closeSilently() {
        try {
            this.close();
        }
        catch (Exception e) {
            logger.warn("File close failed for {},{},{}", new Object[]{this.fileName, this.treeConnect, this.fileId, e});
        }
    }

    public String toString() {
        return String.format("File{fileId=%s, fileName='%s'}", this.fileId, this.fileName);
    }
}

