/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.SecurityDescriptor;
import com.hierynomus.msdtyp.SecurityInformation;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.FileInformationClass;
import com.hierynomus.msfscc.fileinformation.FileInfo;
import com.hierynomus.msfscc.fileinformation.FileInformationFactory;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.messages.SMB2Close;
import com.hierynomus.mssmb2.messages.SMB2CreateRequest;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoRequest;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2SetInfoRequest;
import com.hierynomus.mssmb2.messages.SMB2SetInfoResponse;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.common.SMBBuffer;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.Directory;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.share.Share;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskShare
extends Share {
    private static final Logger logger = LoggerFactory.getLogger(DiskShare.class);

    public DiskShare(SmbPath smbPath, TreeConnect treeConnect) {
        super(smbPath, treeConnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInfo> list(String path) throws SMBApiException, TransportException {
        logger.info("List {}", (Object)path);
        Directory fileHandle = this.openDirectory(path, EnumSet.of(AccessMask.GENERIC_READ), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN);
        try {
            List<FileInfo> list = fileHandle.list();
            return list;
        }
        finally {
            if (fileHandle != null) {
                fileHandle.closeSilently();
            }
        }
    }

    public DiskEntry getFile(String path) {
        FileInfo fileInformation = this.getFileInformation(path);
        EnumSet<FileAttributes> fileAttributes = EnumWithValue.EnumUtils.toEnumSet(fileInformation.getFileAttributes(), FileAttributes.class);
        if (fileAttributes.contains(FileAttributes.FILE_ATTRIBUTE_DIRECTORY)) {
            return new Directory(null, this.treeConnect, path);
        }
        return new File(null, this.treeConnect, path, fileInformation.getAccessMask());
    }

    public Directory openDirectory(String path, EnumSet<AccessMask> accessMask, EnumSet<SMB2ShareAccess> shareAccess, SMB2CreateDisposition createDisposition) throws TransportException, SMBApiException {
        logger.info("OpenDirectory {},{},{},{},{}", new Object[]{path, accessMask, shareAccess, createDisposition});
        SMB2FileId fileId = this.open(path, EnumWithValue.EnumUtils.toLong(accessMask), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_DIRECTORY), shareAccess, createDisposition, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
        return new Directory(fileId, this.treeConnect, path);
    }

    public File openFile(String path, EnumSet<AccessMask> accessMask, SMB2CreateDisposition createDisposition) throws TransportException, SMBApiException {
        logger.info("OpenFile {},{},{}", new Object[]{path, accessMask, createDisposition});
        SMB2FileId fileId = this.open(path, EnumWithValue.EnumUtils.toLong(accessMask), null, EnumSet.of(SMB2ShareAccess.FILE_SHARE_READ), createDisposition, EnumSet.of(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));
        return new File(fileId, this.treeConnect, path, 0L);
    }

    public boolean fileExists(String path) throws SMBApiException {
        logger.info("file exists {}", (Object)path);
        return this.exists(path, EnumSet.of(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));
    }

    public boolean folderExists(String path) throws SMBApiException {
        logger.info("Checking existence of Directory '{}' on {}", (Object)path, (Object)this.smbPath);
        return this.exists(path, EnumSet.of(SMB2CreateOptions.FILE_DIRECTORY_FILE));
    }

    public void mkdir(String path) throws TransportException, SMBApiException {
        logger.info("mkdir {}", (Object)path);
        Directory fileHandle = this.openDirectory(path, EnumSet.of(AccessMask.FILE_LIST_DIRECTORY, AccessMask.FILE_ADD_SUBDIRECTORY), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_CREATE);
        fileHandle.close();
    }

    public FileInfo getFileInformation(String path) throws SMBApiException {
        byte[] outputBuffer = this.queryInfoCommon(path, SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_FILE, null, FileInformationClass.FileAllInformation);
        try {
            return FileInformationFactory.parseFileAllInformation(new Buffer.PlainBuffer(outputBuffer, Endian.LE));
        }
        catch (Buffer.BufferException e) {
            throw new SMBRuntimeException(e);
        }
    }

    public FileInfo getFileInformation(SMB2FileId fileId) throws SMBApiException, TransportException {
        byte[] outputBuffer = this.queryInfoCommon(fileId, SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_FILE, null, FileInformationClass.FileAllInformation);
        try {
            return FileInformationFactory.parseFileAllInformation(new Buffer.PlainBuffer(outputBuffer, Endian.LE));
        }
        catch (Buffer.BufferException e) {
            throw new TransportException(e);
        }
    }

    public void rmdir(String path, boolean recursive) throws TransportException, SMBApiException {
        logger.info("rmdir {},{}", (Object)path, (Object)recursive);
        if (recursive) {
            List<FileInfo> list = this.list(path);
            for (FileInfo fi : list) {
                if (!EnumWithValue.EnumUtils.isSet(fi.getFileAttributes(), FileAttributes.FILE_ATTRIBUTE_DIRECTORY)) {
                    this.rm(this.makePath(path, fi.getFileName()));
                    continue;
                }
                this.rmdir(this.makePath(path, fi.getFileName()), recursive);
            }
            this.rmdir(path, false);
        } else {
            SMB2CreateRequest smb2CreateRequest = DiskShare.openFileRequest(this.treeConnect, path, AccessMask.DELETE.getValue(), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_DIRECTORY), SMB2CreateDisposition.FILE_OPEN, null);
            this.deleteCommon(path, smb2CreateRequest);
        }
    }

    public void rm(String path) throws TransportException, SMBApiException {
        logger.info("rm {}", (Object)path);
        SMB2CreateRequest smb2CreateRequest = DiskShare.openFileRequest(this.treeConnect, path, AccessMask.DELETE.getValue(), null, null, SMB2CreateDisposition.FILE_OPEN, EnumSet.of(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE));
        this.deleteCommon(path, smb2CreateRequest);
    }

    public SecurityDescriptor getSecurityInfo(String path, EnumSet<SecurityInformation> securityInfo) throws SMBApiException, TransportException {
        byte[] outputBuffer = this.queryInfoCommon(path, SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_SECURITY, securityInfo, null);
        SecurityDescriptor sd = new SecurityDescriptor();
        try {
            sd.read(new SMBBuffer(outputBuffer));
        }
        catch (Buffer.BufferException e) {
            throw new TransportException(e);
        }
        return sd;
    }

    public SecurityDescriptor getSecurityInfo(SMB2FileId fileId, EnumSet<SecurityInformation> securityInfo) throws SMBApiException, TransportException {
        byte[] outputBuffer = this.queryInfoCommon(fileId, SMB2QueryInfoRequest.SMB2QueryInfoType.SMB2_0_INFO_SECURITY, securityInfo, null);
        SecurityDescriptor sd = new SecurityDescriptor();
        try {
            sd.read(new SMBBuffer(outputBuffer));
        }
        catch (Buffer.BufferException e) {
            throw new TransportException(e);
        }
        return sd;
    }

    private String makePath(String first, String ... more) {
        StringBuilder sb = new StringBuilder(first);
        for (int i = 0; i < more.length; ++i) {
            sb.append('\\');
            sb.append(more[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCommon(String path, SMB2CreateRequest smb2CreateRequest) throws TransportException, SMBApiException {
        Session session = this.treeConnect.getSession();
        Connection connection = session.getConnection();
        Future sendFuture = connection.send(smb2CreateRequest);
        SMB2CreateResponse response = (SMB2CreateResponse)Futures.get(sendFuture, TransportException.Wrapper);
        if (response.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
            throw new SMBApiException(response.getHeader(), "Create failed for " + path);
        }
        SMB2FileId fileId = response.getFileId();
        try {
            byte[] dispoInfo = FileInformationFactory.getFileDispositionInfo(true);
            SMB2SetInfoRequest si_req = new SMB2SetInfoRequest(connection.getNegotiatedProtocol().getDialect(), session.getSessionId(), this.treeConnect.getTreeId(), SMB2SetInfoRequest.SMB2InfoType.SMB2_0_INFO_FILE, fileId, FileInformationClass.FileDispositionInformation, null, dispoInfo);
            Future setInfoFuture = connection.send(si_req);
            SMB2SetInfoResponse setInfoResponse = (SMB2SetInfoResponse)Futures.get(setInfoFuture, TransportException.Wrapper);
            if (setInfoResponse.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(response.getHeader(), "SetInfo failed for " + path);
            }
        }
        finally {
            SMB2Close closeReq = new SMB2Close(connection.getNegotiatedProtocol().getDialect(), session.getSessionId(), this.treeConnect.getTreeId(), fileId);
            Future closeFuture = connection.send(closeReq);
            SMB2Close closeResponse = (SMB2Close)Futures.get(closeFuture, TransportException.Wrapper);
            if (closeResponse.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(response.getHeader(), "Close failed for " + path);
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean exists(String path, EnumSet<SMB2CreateOptions> createOptions) throws SMBApiException {
        boolean bl;
        SMB2FileId fileId;
        block12: {
            logger.info("exists {}", (Object)path);
            fileId = null;
            fileId = this.open(path, EnumWithValue.EnumUtils.toLong(EnumSet.of(AccessMask.FILE_READ_ATTRIBUTES)), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_DIRECTORY), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, createOptions);
            bl = true;
            if (fileId == null) break block12;
            try {
                this.close(fileId);
            }
            catch (Exception e) {
                logger.warn("File close failed for {},{},{}", new Object[]{path, this.treeConnect, fileId, e});
            }
        }
        return bl;
        catch (SMBApiException sae) {
            block13: {
                boolean bl2;
                block14: {
                    try {
                        if (sae.getStatus() != NtStatus.STATUS_OBJECT_NAME_NOT_FOUND) break block13;
                        bl2 = false;
                        if (fileId == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (fileId != null) {
                            try {
                                this.close(fileId);
                            }
                            catch (Exception e) {
                                logger.warn("File close failed for {},{},{}", new Object[]{path, this.treeConnect, fileId, e});
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.close(fileId);
                    }
                    catch (Exception e) {
                        logger.warn("File close failed for {},{},{}", new Object[]{path, this.treeConnect, fileId, e});
                    }
                }
                return bl2;
            }
            throw sae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] queryInfoCommon(String path, SMB2QueryInfoRequest.SMB2QueryInfoType infoType, EnumSet<SecurityInformation> securityInfo, FileInformationClass fileInformationClass) throws SMBApiException {
        byte[] byArray;
        block7: {
            SMB2FileId fileId = null;
            try {
                fileId = this.open(path, EnumWithValue.EnumUtils.toLong(EnumSet.of(AccessMask.GENERIC_READ)), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_DELETE, SMB2ShareAccess.FILE_SHARE_WRITE, SMB2ShareAccess.FILE_SHARE_READ), SMB2CreateDisposition.FILE_OPEN, null);
                byArray = this.queryInfoCommon(fileId, infoType, securityInfo, fileInformationClass);
                if (fileId == null) break block7;
            }
            catch (Throwable throwable) {
                if (fileId != null) {
                    try {
                        this.close(fileId);
                    }
                    catch (Exception e) {
                        logger.warn("File close failed for {},{},{}", new Object[]{path, this.treeConnect, fileId, e});
                    }
                }
                throw throwable;
            }
            try {
                this.close(fileId);
            }
            catch (Exception e) {
                logger.warn("File close failed for {},{},{}", new Object[]{path, this.treeConnect, fileId, e});
            }
        }
        return byArray;
    }

    private byte[] queryInfoCommon(SMB2FileId fileId, SMB2QueryInfoRequest.SMB2QueryInfoType infoType, EnumSet<SecurityInformation> securityInfo, FileInformationClass fileInformationClass) throws SMBApiException {
        Session session = this.treeConnect.getSession();
        Connection connection = session.getConnection();
        SMB2QueryInfoRequest qreq = new SMB2QueryInfoRequest(connection.getNegotiatedProtocol().getDialect(), session.getSessionId(), this.treeConnect.getTreeId(), fileId, infoType, fileInformationClass, null, null, securityInfo);
        try {
            Future qiResponseFuture = connection.send(qreq);
            SMB2QueryInfoResponse qresp = (SMB2QueryInfoResponse)Futures.get(qiResponseFuture, SMBRuntimeException.Wrapper);
            if (qresp.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(qresp.getHeader(), "QUERY_INFO failed for " + fileId);
            }
            return qresp.getOutputBuffer();
        }
        catch (TransportException e) {
            throw SMBRuntimeException.Wrapper.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAccessMask(AccessMask mask, String smbPathOnShare) {
        boolean bl;
        File file = null;
        try {
            file = this.openFile(smbPathOnShare, EnumSet.of(mask), SMB2CreateDisposition.FILE_OPEN);
            bl = file != null;
        }
        catch (TransportException e) {
            try {
                throw new IllegalStateException("Exception occurred while trying to determine permissions on file", e);
                catch (SMBApiException e2) {
                    boolean bl2 = this.checkPermissions(e2);
                    this.close(file);
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                this.close(file);
                throw throwable;
            }
        }
        this.close(file);
        return bl;
    }

    private boolean checkPermissions(SMBApiException e) {
        if (e.getStatus().equals(NtStatus.STATUS_ACCESS_DENIED)) {
            return false;
        }
        throw e;
    }

    private void close(File file) {
        try {
            this.close(file.getFileId());
        }
        catch (TransportException e) {
            throw new IllegalStateException("Exception occured while trying to determine permissions on file", e);
        }
    }
}

