/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.messages.SMB2WriteRequest;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.ProgressListener;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.io.ByteChunkProvider;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.FileInputStream;
import com.hierynomus.smbj.share.FileOutputStream;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
extends DiskEntry {
    private static final Logger logger = LoggerFactory.getLogger(File.class);
    private final long accessMask;

    public File(SMB2FileId fileId, TreeConnect treeConnect, String fileName, long accessMask) {
        super(treeConnect, fileId, fileName);
        this.accessMask = accessMask;
    }

    public void write(ByteChunkProvider provider, ProgressListener progressListener) throws TransportException {
        Session session = this.treeConnect.getSession();
        Connection connection = session.getConnection();
        while (provider.isAvailable()) {
            logger.debug("Writing to {} from offset {}", (Object)this.fileName, (Object)provider.getOffset());
            SMB2WriteRequest wreq = new SMB2WriteRequest(connection.getNegotiatedProtocol().getDialect(), this.getFileId(), session.getSessionId(), this.treeConnect.getTreeId(), provider, connection.getNegotiatedProtocol().getMaxWriteSize());
            Future writeFuture = connection.send(wreq);
            SMB2WriteResponse wresp = (SMB2WriteResponse)Futures.get(writeFuture, TransportException.Wrapper);
            if (wresp.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(wresp.getHeader(), "Write failed for " + this);
            }
            if (progressListener == null) continue;
            progressListener.onProgressChanged(wresp.getBytesWritten(), provider.getOffset());
        }
    }

    public void write(ByteChunkProvider provider) throws IOException {
        this.write(provider, null);
    }

    public void read(OutputStream destStream) throws IOException {
        this.read(destStream, null);
    }

    public void read(OutputStream destStream, ProgressListener progressListener) throws IOException {
        Session session = this.treeConnect.getSession();
        Connection connection = session.getConnection();
        InputStream is = this.getInputStream(progressListener);
        int numRead = -1;
        byte[] buf = new byte[connection.getNegotiatedProtocol().getMaxWriteSize()];
        while ((numRead = is.read(buf)) != -1) {
            destStream.write(buf, 0, numRead);
        }
        is.close();
    }

    public InputStream getInputStream() {
        return this.getInputStream(null);
    }

    private InputStream getInputStream(ProgressListener listener) {
        return new FileInputStream(this, listener);
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(null);
    }

    public OutputStream getOutputStream(ProgressListener listener) {
        return new FileOutputStream(this, listener);
    }

    public String toString() {
        return "File{fileId=" + this.fileId + ", fileName='" + this.fileName + '\'' + '}';
    }
}

