/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

class RingBuffer {
    private byte[] buf;
    private int writeIndex;
    private int size;

    public RingBuffer(int maxSize) {
        this.buf = new byte[maxSize];
    }

    public void write(byte[] b, int off, int len) {
        if (b.length - off < len) {
            throw new IllegalArgumentException("Bytes to write do not exist in source");
        }
        if (len > this.buf.length - this.size) {
            throw new IndexOutOfBoundsException("Size of bytes to be written is greater than available buffer space");
        }
        this.writeBytes(b, off, len);
        this.size += len;
    }

    public void write(int b) {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public int read(byte[] chunk) {
        int len = this.size < chunk.length ? this.size : chunk.length;
        this.readBytes(chunk, len);
        this.size -= len;
        return len;
    }

    public int getUsedSize() {
        return this.size;
    }

    private void readBytes(byte[] b, int i) {
        int readIndex = this.writeIndex - this.size;
        if (readIndex > 0) {
            System.arraycopy(this.buf, readIndex, b, 0, i);
        } else {
            int bytesToEnd = this.buf.length - (readIndex += this.buf.length);
            System.arraycopy(this.buf, readIndex, b, 0, bytesToEnd);
            System.arraycopy(this.buf, 0, b, bytesToEnd, i - bytesToEnd);
        }
    }

    private void writeBytes(byte[] b, int off, int len) {
        if (this.writeIndex + len <= this.buf.length) {
            System.arraycopy(b, off, this.buf, this.writeIndex, len);
            this.writeIndex += len;
        } else {
            int bytesToEnd = this.buf.length - this.writeIndex;
            System.arraycopy(b, off, this.buf, this.writeIndex, bytesToEnd);
            System.arraycopy(b, bytesToEnd, this.buf, bytesToEnd, len - bytesToEnd);
            this.writeIndex = len - bytesToEnd;
        }
    }

    public boolean isFull() {
        return this.size == this.buf.length;
    }

    public boolean isFull(int len) {
        return this.size + len > this.buf.length;
    }

    public boolean hasData() {
        return this.size > 0;
    }
}

