/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.SMB2ShareCapabilities;
import com.hierynomus.mssmb2.messages.SMB2TreeDisconnect;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.event.SMBEventBus;
import com.hierynomus.smbj.event.TreeDisconnected;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.Share;
import com.hierynomus.smbj.transport.TransportException;
import java.util.EnumSet;
import java.util.concurrent.Future;

public class TreeConnect {
    private long treeId;
    private SmbPath smbPath;
    private Session session;
    private final boolean isDfsShare;
    private final boolean isCAShare;
    private final boolean isScaleoutShare;
    private final EnumSet<SMB2ShareCapabilities> capabilities;
    private Connection connection;
    private final SMBEventBus bus;
    private Share handle;

    public TreeConnect(long treeId, SmbPath smbPath, Session session, EnumSet<SMB2ShareCapabilities> capabilities, Connection connection, SMBEventBus bus) {
        this.treeId = treeId;
        this.smbPath = smbPath;
        this.session = session;
        this.isDfsShare = capabilities.contains(SMB2ShareCapabilities.SMB2_SHARE_CAP_DFS);
        this.isCAShare = capabilities.contains(SMB2ShareCapabilities.SMB2_SHARE_CAP_CONTINUOUS_AVAILABILITY);
        this.isScaleoutShare = capabilities.contains(SMB2ShareCapabilities.SMB2_SHARE_CAP_SCALEOUT);
        this.capabilities = capabilities;
        this.connection = connection;
        this.bus = bus;
    }

    Connection getConnection() {
        return this.connection;
    }

    void close(Share share) throws TransportException {
        SMB2TreeDisconnect disconnect = new SMB2TreeDisconnect(this.connection.getNegotiatedProtocol().getDialect(), this.session.getSessionId(), this.treeId);
        Future send = this.connection.send(disconnect);
        SMB2Packet smb2Packet = (SMB2Packet)Futures.get(send, TransportException.Wrapper);
        if (!smb2Packet.getHeader().getStatus().isSuccess()) {
            throw new SMBApiException(smb2Packet.getHeader(), "Error closing connection to " + this.smbPath);
        }
        this.bus.publish(new TreeDisconnected(this.session.getSessionId(), this.treeId));
    }

    void setHandle(Share handle) {
        this.handle = handle;
    }

    public String getShareName() {
        return this.smbPath.getShareName();
    }

    public Share getHandle() {
        return this.handle;
    }

    public long getTreeId() {
        return this.treeId;
    }

    public Session getSession() {
        return this.session;
    }

    public String toString() {
        return String.format("TreeConnect[%s](%s)", this.treeId, this.smbPath);
    }
}

