/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2IoctlRequest;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;

public class SMB2IoctlResponse
extends SMB2Packet {
    private SMB2IoctlRequest.ControlCode controlCode;
    private SMB2FileId fileId;
    byte[] inputBuffer;
    byte[] outputBuffer;

    @Override
    protected void readMessage(SMBBuffer buffer) throws Buffer.BufferException {
        if (this.header.getStatus() != NtStatus.STATUS_SUCCESS) {
            return;
        }
        buffer.skip(2);
        buffer.skip(2);
        this.controlCode = EnumWithValue.EnumUtils.valueOf(buffer.readUInt32(), SMB2IoctlRequest.ControlCode.class, null);
        this.fileId = SMB2FileId.read(buffer);
        int inputOffset = buffer.readUInt32AsInt();
        int inputCount = buffer.readUInt32AsInt();
        int outputOffset = buffer.readUInt32AsInt();
        int outputCount = buffer.readUInt32AsInt();
        buffer.skip(4);
        buffer.skip(4);
        if (inputCount > 0) {
            buffer.rpos(inputOffset);
            this.inputBuffer = buffer.readRawBytes(inputCount);
        }
        if (outputCount > 0) {
            buffer.rpos(outputOffset);
            this.outputBuffer = buffer.readRawBytes(outputCount);
        }
    }

    public byte[] getOutputBuffer() {
        return this.outputBuffer;
    }

    public byte[] getInputBuffer() {
        return this.inputBuffer;
    }
}

