/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.session;

import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2Header;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSignatory {
    private static final Logger logger = LoggerFactory.getLogger(PacketSignatory.class);
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final byte[] EMPTY_SIGNATURE = new byte[16];
    private SMB2Dialect dialect;
    private SecretKeySpec secretKey;

    public PacketSignatory(SMB2Dialect dialect) {
        this.dialect = dialect;
    }

    void init(byte[] secretKey) {
        if (this.dialect.isSmb3x()) {
            throw new IllegalStateException("Cannot set a signing key (yet) for SMB3.x");
        }
        this.secretKey = new SecretKeySpec(secretKey, HMAC_SHA256_ALGORITHM);
    }

    boolean isInitialized() {
        return this.secretKey != null;
    }

    SMB2Packet sign(SMB2Packet packet) {
        if (this.secretKey != null) {
            return new SignedPacketWrapper(packet, this.secretKey);
        }
        logger.debug("Not wrapping {} as signed, as no key is set.", (Object)packet.getHeader().getMessage());
        return packet;
    }

    public boolean verify(SMB2Packet packet) {
        try {
            Mac mac = PacketSignatory.getMac(this.secretKey);
            SMBBuffer buffer = packet.getBuffer();
            mac.update(buffer.array(), 0, 48);
            mac.update(EMPTY_SIGNATURE);
            mac.update(buffer.array(), 64, buffer.available() - 64);
            byte[] signature = mac.doFinal();
            byte[] receivedSignature = Arrays.copyOfRange(buffer.array(), 48, 64);
            for (int i = 0; i < 16; ++i) {
                if (signature[i] == receivedSignature[i]) continue;
                return false;
            }
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Mac getMac(SecretKeySpec signingKeySpec) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(signingKeySpec.getAlgorithm());
        mac.init(signingKeySpec);
        return mac;
    }

    static {
        Arrays.fill(EMPTY_SIGNATURE, (byte)0);
    }

    public static class SignedPacketWrapper
    extends SMB2Packet {
        private final SMB2Packet wrappedPacket;
        private final SecretKeySpec secretKey;

        SignedPacketWrapper(SMB2Packet packet, SecretKeySpec secretKey) {
            this.wrappedPacket = packet;
            this.secretKey = secretKey;
        }

        @Override
        public int getMaxPayloadSize() {
            return this.wrappedPacket.getMaxPayloadSize();
        }

        @Override
        public void write(SMBBuffer buffer) {
            try {
                int packetStartPos = buffer.wpos();
                SigningBuffer signingBuffer = new SigningBuffer(buffer, this.secretKey);
                this.wrappedPacket.write(signingBuffer);
                byte[] signature = signingBuffer.mac.doFinal();
                System.arraycopy(signature, 0, buffer.array(), packetStartPos + 48, 16);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public SMB2Header getHeader() {
            return this.wrappedPacket.getHeader();
        }

        @Override
        public long getSequenceNumber() {
            return this.wrappedPacket.getSequenceNumber();
        }

        @Override
        public int getStructureSize() {
            return this.wrappedPacket.getStructureSize();
        }

        private class SigningBuffer
        extends SMBBuffer {
            private SMBBuffer wrappedBuffer;
            private final Mac mac;

            public SigningBuffer(SMBBuffer wrappedBuffer, SecretKeySpec signingKeySpec) throws NoSuchAlgorithmException, InvalidKeyException {
                this.wrappedBuffer = wrappedBuffer;
                this.mac = PacketSignatory.getMac(signingKeySpec);
            }

            @Override
            public Buffer<SMBBuffer> putByte(byte b) {
                this.mac.update(b);
                this.wrappedBuffer.putByte(b);
                return this;
            }

            @Override
            public Buffer<SMBBuffer> putBuffer(Buffer<? extends Buffer<?>> buffer) {
                this.mac.update(buffer.array(), buffer.rpos(), buffer.available());
                this.wrappedBuffer.putBuffer(buffer);
                return this;
            }

            @Override
            public Buffer<SMBBuffer> putRawBytes(byte[] buf, int offset, int length) {
                this.mac.update(buf, offset, length);
                this.wrappedBuffer.putRawBytes(buf, offset, length);
                return this;
            }
        }
    }
}

