/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.session;

import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.SMB2ShareCapabilities;
import com.hierynomus.mssmb2.messages.SMB2Logoff;
import com.hierynomus.mssmb2.messages.SMB2TreeConnectRequest;
import com.hierynomus.mssmb2.messages.SMB2TreeConnectResponse;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.event.SMBEventBus;
import com.hierynomus.smbj.event.SessionLoggedOff;
import com.hierynomus.smbj.event.TreeDisconnected;
import com.hierynomus.smbj.session.PacketSignatory;
import com.hierynomus.smbj.session.TreeConnectTable;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.NamedPipe;
import com.hierynomus.smbj.share.PrinterShare;
import com.hierynomus.smbj.share.Share;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.util.concurrent.Future;
import net.engio.mbassy.listener.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private long sessionId;
    private PacketSignatory packetSignatory;
    private boolean serverSigningRequired;
    private Connection connection;
    private SMBEventBus bus;
    private TreeConnectTable treeConnectTable = new TreeConnectTable();

    public Session(long sessionId, Connection connection, SMBEventBus bus, boolean signingRequired) {
        this.sessionId = sessionId;
        this.connection = connection;
        this.bus = bus;
        this.packetSignatory = new PacketSignatory(connection.getNegotiatedProtocol().getDialect());
        this.serverSigningRequired = signingRequired;
        if (bus != null) {
            bus.subscribe(this);
        }
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Share connectShare(String shareName) {
        TreeConnect connectedConnect = this.treeConnectTable.getTreeConnect(shareName);
        if (connectedConnect != null) {
            logger.info("Returning cached Share {} for {}", (Object)connectedConnect.getTreeId(), (Object)shareName);
            return connectedConnect.getHandle();
        }
        return this.connectTree(shareName);
    }

    private Share connectTree(String shareName) {
        String remoteHostname = this.connection.getRemoteHostname();
        SmbPath smbPath = new SmbPath(remoteHostname, shareName);
        logger.info("Connection to {} on session {}", (Object)smbPath, (Object)this.sessionId);
        try {
            SMB2TreeConnectRequest smb2TreeConnectRequest = new SMB2TreeConnectRequest(this.connection.getNegotiatedProtocol().getDialect(), smbPath, this.sessionId);
            smb2TreeConnectRequest.getHeader().setCreditRequest(256);
            Future send = this.send(smb2TreeConnectRequest);
            SMB2TreeConnectResponse response = (SMB2TreeConnectResponse)Futures.get(send, TransportException.Wrapper);
            if (response.getHeader().getStatus().isError()) {
                logger.debug(response.getHeader().toString());
                throw new SMBApiException(response.getHeader(), "Could not connect to " + smbPath);
            }
            if (response.getCapabilities().contains(SMB2ShareCapabilities.SMB2_SHARE_CAP_ASYMMETRIC)) {
                throw new SMBRuntimeException("ASYMMETRIC capability unsupported");
            }
            long treeId = response.getHeader().getTreeId();
            TreeConnect treeConnect = new TreeConnect(treeId, smbPath, this, response.getCapabilities(), this.connection, this.bus);
            this.treeConnectTable.register(treeConnect);
            if (response.isDiskShare()) {
                return new DiskShare(smbPath, treeConnect);
            }
            if (response.isNamedPipe()) {
                return new NamedPipe(smbPath, treeConnect);
            }
            if (response.isPrinterShare()) {
                return new PrinterShare(smbPath, treeConnect);
            }
            throw new SMBRuntimeException("Unknown ShareType returned in the TREE_CONNECT Response");
        }
        catch (TransportException e) {
            throw new SMBRuntimeException(e);
        }
    }

    @Handler
    private void disconnectTree(TreeDisconnected disconnectEvent) {
        if (disconnectEvent.getSessionId() == this.sessionId) {
            logger.debug("Notified of TreeDisconnected <<{}>>", (Object)disconnectEvent.getTreeId());
            this.treeConnectTable.closed(disconnectEvent.getTreeId());
        }
    }

    public void logoff() throws TransportException {
        logger.info("Logging off session {} from host {}", (Object)this.sessionId, (Object)this.connection.getRemoteHostname());
        for (TreeConnect treeConnect : this.treeConnectTable.getOpenTreeConnects()) {
            try {
                treeConnect.getHandle().close();
            }
            catch (IOException e) {
                logger.error("Caught exception while closing TreeConnect with id: {}", (Object)treeConnect.getTreeId(), (Object)e);
            }
        }
        SMB2Logoff logoff = new SMB2Logoff(this.connection.getNegotiatedProtocol().getDialect(), this.sessionId);
        SMB2Logoff response = (SMB2Logoff)Futures.get(this.send(logoff), TransportException.Wrapper);
        if (!response.getHeader().getStatus().isSuccess()) {
            throw new SMBApiException(response.getHeader(), "Could not logoff session <<" + this.sessionId + ">>");
        }
        this.bus.publish(new SessionLoggedOff(this.sessionId));
    }

    public boolean isSigningRequired() {
        return this.serverSigningRequired;
    }

    public void setSigningKey(byte[] signingKeyBytes) {
        this.packetSignatory.init(signingKeyBytes);
    }

    @Override
    public void close() throws IOException {
        this.logoff();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public <T extends SMB2Packet> Future<T> send(SMB2Packet packet) throws TransportException {
        if (this.serverSigningRequired && !this.packetSignatory.isInitialized()) {
            throw new TransportException("Message signing is required, but no signing key is negotiated");
        }
        return this.connection.send(this.packetSignatory.sign(packet));
    }

    public void setBus(SMBEventBus bus) {
        if (this.bus != null) {
            this.bus.unsubscribe(this);
            this.bus = null;
        }
        this.bus = bus;
        bus.subscribe(this);
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public PacketSignatory getPacketSignatory() {
        return this.packetSignatory;
    }
}

