/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.auth;

import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.ntlm.messages.AvId;
import com.hierynomus.ntlm.messages.NtlmAuthenticate;
import com.hierynomus.ntlm.messages.NtlmChallenge;
import com.hierynomus.ntlm.messages.NtlmNegotiate;
import com.hierynomus.ntlm.messages.NtlmNegotiateFlag;
import com.hierynomus.protocol.commons.ByteArrayUtils;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.Factory;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.security.SecurityProvider;
import com.hierynomus.smbj.auth.AuthenticateResponse;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.auth.Authenticator;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.spnego.NegTokenInit;
import com.hierynomus.spnego.NegTokenTarg;
import com.hierynomus.spnego.SpnegoException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.Random;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.microsoft.MicrosoftObjectIdentifiers;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(NtlmAuthenticator.class);
    private static final ASN1ObjectIdentifier NTLMSSP = MicrosoftObjectIdentifiers.microsoft.branch("2.2.10");
    private SecurityProvider securityProvider;
    private Random random;
    private boolean initialized = false;
    private boolean completed = false;

    @Override
    public AuthenticateResponse authenticate(AuthenticationContext context, byte[] gssToken, Session session) throws IOException {
        try {
            byte[] sessionkey;
            AuthenticateResponse response = new AuthenticateResponse();
            if (this.completed) {
                return null;
            }
            if (!this.initialized) {
                logger.debug("Initialized Authentication of {} using NTLM", (Object)context.getUsername());
                NtlmNegotiate ntlmNegotiate = new NtlmNegotiate();
                this.initialized = true;
                response.setNegToken(this.negTokenInit(ntlmNegotiate));
                return response;
            }
            logger.debug("Received token: {}", (Object)ByteArrayUtils.printHex(gssToken));
            NtlmFunctions ntlmFunctions = new NtlmFunctions(this.random, this.securityProvider);
            NegTokenTarg negTokenTarg = new NegTokenTarg().read(gssToken);
            BigInteger negotiationResult = negTokenTarg.getNegotiationResult();
            NtlmChallenge challenge = new NtlmChallenge();
            try {
                challenge.read(new Buffer.PlainBuffer(negTokenTarg.getResponseToken(), Endian.LE));
            }
            catch (Buffer.BufferException e) {
                throw new IOException(e);
            }
            logger.debug("Received NTLM challenge from: {}", (Object)challenge.getTargetName());
            response.setWindowsVersion(challenge.getVersion());
            byte[] serverChallenge = challenge.getServerChallenge();
            byte[] responseKeyNT = ntlmFunctions.NTOWFv2(String.valueOf(context.getPassword()), context.getUsername(), context.getDomain());
            byte[] ntlmv2ClientChallenge = ntlmFunctions.getNTLMv2ClientChallenge(challenge.getTargetInfo());
            byte[] ntlmv2Response = ntlmFunctions.getNTLMv2Response(responseKeyNT, serverChallenge, ntlmv2ClientChallenge);
            byte[] userSessionKey = ntlmFunctions.hmac_md5(responseKeyNT, new byte[][]{Arrays.copyOfRange((byte[])ntlmv2Response, (int)0, (int)16)});
            EnumSet<NtlmNegotiateFlag> negotiateFlags = challenge.getNegotiateFlags();
            if (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_KEY_EXCH) && (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_SIGN) || negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_SEAL) || negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_ALWAYS_SIGN))) {
                byte[] masterKey = new byte[16];
                this.random.nextBytes(masterKey);
                sessionkey = ntlmFunctions.encryptRc4(userSessionKey, masterKey);
                response.setSigningKey(masterKey);
            } else {
                sessionkey = userSessionKey;
                response.setSigningKey(sessionkey);
            }
            this.completed = true;
            Object msvAvFlags = challenge.getAvPairObject(AvId.MsvAvFlags);
            if (msvAvFlags instanceof Long && ((Long)msvAvFlags & 2L) > 0L) {
                NtlmAuthenticate resp = new NtlmAuthenticate(new byte[0], ntlmv2Response, context.getUsername(), context.getDomain(), null, sessionkey, EnumWithValue.EnumUtils.toLong(negotiateFlags), true);
                Buffer.PlainBuffer concatenatedBuffer = new Buffer.PlainBuffer(Endian.LE);
                concatenatedBuffer.putRawBytes(negTokenTarg.getResponseToken());
                concatenatedBuffer.putRawBytes(challenge.getServerChallenge());
                resp.writeAutentificateMessage(concatenatedBuffer);
                byte[] mic = ntlmFunctions.hmac_md5(userSessionKey, new byte[][]{concatenatedBuffer.getCompactData()});
                resp.setMic(mic);
                response.setNegToken(this.negTokenTarg(resp, negTokenTarg.getResponseToken()));
                return response;
            }
            NtlmAuthenticate resp = new NtlmAuthenticate(new byte[0], ntlmv2Response, context.getUsername(), context.getDomain(), null, sessionkey, EnumWithValue.EnumUtils.toLong(negotiateFlags), false);
            response.setNegToken(this.negTokenTarg(resp, negTokenTarg.getResponseToken()));
            return response;
        }
        catch (SpnegoException spne) {
            throw new SMBRuntimeException(spne);
        }
    }

    private byte[] negTokenInit(NtlmNegotiate ntlmNegotiate) throws SpnegoException {
        NegTokenInit negTokenInit = new NegTokenInit();
        negTokenInit.addSupportedMech(NTLMSSP);
        Buffer.PlainBuffer ntlmBuffer = new Buffer.PlainBuffer(Endian.LE);
        ntlmNegotiate.write(ntlmBuffer);
        negTokenInit.setMechToken(ntlmBuffer.getCompactData());
        Buffer.PlainBuffer negTokenBuffer = new Buffer.PlainBuffer(Endian.LE);
        negTokenInit.write(negTokenBuffer);
        return negTokenBuffer.getCompactData();
    }

    private byte[] negTokenTarg(NtlmAuthenticate resp, byte[] responseToken) throws SpnegoException {
        NegTokenTarg targ = new NegTokenTarg();
        targ.setResponseToken(responseToken);
        Buffer.PlainBuffer ntlmBuffer = new Buffer.PlainBuffer(Endian.LE);
        resp.write(ntlmBuffer);
        targ.setResponseToken(ntlmBuffer.getCompactData());
        Buffer.PlainBuffer negTokenBuffer = new Buffer.PlainBuffer(Endian.LE);
        targ.write(negTokenBuffer);
        return negTokenBuffer.getCompactData();
    }

    @Override
    public void init(SecurityProvider securityProvider, Random random) {
        this.securityProvider = securityProvider;
        this.random = random;
    }

    @Override
    public boolean supports(AuthenticationContext context) {
        return context.getClass().equals(AuthenticationContext.class);
    }

    public static class Factory
    implements Factory.Named<Authenticator> {
        @Override
        public String getName() {
            return "1.3.6.1.4.1.311.2.2.10";
        }

        @Override
        public NtlmAuthenticator create() {
            return new NtlmAuthenticator();
        }
    }
}

