/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2Header;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DFSPathResolver;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.PathResolveException;
import com.hierynomus.smbj.share.TreeConnect;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSDiskShare
extends DiskShare {
    private static final Logger logger = LoggerFactory.getLogger(DFSDiskShare.class);
    private final DFSPathResolver dfsPathResolver = new DFSPathResolver();

    public DFSDiskShare(SmbPath smbPath, TreeConnect treeConnect) {
        super(smbPath, treeConnect);
    }

    @Override
    public DiskEntry open(String path, Set<AccessMask> accessMask, Set<FileAttributes> attributes, Set<SMB2ShareAccess> shareAccesses, SMB2CreateDisposition createDisposition, Set<SMB2CreateOptions> createOptions) {
        SMB2CreateResponse response = this.createFile(path, null, accessMask, attributes, shareAccesses, createDisposition, createOptions);
        if (((SMB2Header)response.getHeader()).getStatus() == NtStatus.STATUS_PATH_NOT_COVERED) {
            logger.info("DFS Share {} does not cover {}, resolve through DFS", (Object)this, (Object)path);
            try {
                SmbPath smbPath = new SmbPath(this.getSmbPath(), path);
                SmbPath resolved = SmbPath.parse(this.dfsPathResolver.resolve(this.getTreeConnect().getSession(), smbPath.toUncPath()));
                logger.info("DFS resolved {} -> {}", (Object)smbPath, (Object)resolved);
                if (!resolved.getHostname().equals(smbPath.getHostname())) {
                    SMBClient client = this.getTreeConnect().getConnection().getClient();
                    try {
                        Connection connect = client.connect(resolved.getHostname());
                        Session session = connect.authenticate(this.getTreeConnect().getSession().getAuthenticationContext());
                        DiskShare share = (DiskShare)session.connectShare(resolved.getShareName());
                        return share.open(resolved.getPath(), accessMask, attributes, shareAccesses, createDisposition, createOptions);
                    }
                    catch (IOException e) {
                        throw new SMBApiException((SMB2Header)response.getHeader(), "Cannot connect to resolved path " + resolved, (Throwable)e);
                    }
                }
            }
            catch (PathResolveException e) {
                throw new SMBApiException((SMB2Header)response.getHeader(), "Cannot resolve DFS path for " + path);
            }
        }
        return this.getDiskEntry(path, response);
    }

    @Override
    protected EnumSet<NtStatus> getCreateSuccessStatus() {
        EnumSet<NtStatus> status = EnumSet.copyOf(super.getCreateSuccessStatus());
        status.add(NtStatus.STATUS_PATH_NOT_COVERED);
        return status;
    }
}

