/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.comparison;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.text.TextMeasurer;
import com.himanshoe.charty.bar.config.ComparisonBarChartConfig;
import com.himanshoe.charty.bar.config.ComparisonBarSegment;
import com.himanshoe.charty.bar.config.NegativeValuesDrawMode;
import com.himanshoe.charty.bar.data.BarGroup;
import com.himanshoe.charty.bar.internal.bar.comparison.ComparisonBarChartHelpersKt;
import com.himanshoe.charty.bar.internal.bar.comparison.ComparisonBarDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.draw.ChartDrawUtilsKt;
import com.himanshoe.charty.common.tooltip.TooltipState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001aL\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000fH\u0002\u001a$\u0010\u001b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u001a.\u0010\"\u001a\u00020\u0001*\u00020\u00022\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a8\u0006%"}, d2={"drawComparisonBars", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "params", "Lcom/himanshoe/charty/bar/internal/bar/comparison/ComparisonBarDrawParams;", "getComparisonBarColor", "Lcom/himanshoe/charty/color/ChartyColor;", "group", "Lcom/himanshoe/charty/bar/data/BarGroup;", "barIndex", "", "createComparisonBarBrush", "Landroidx/compose/ui/graphics/Brush;", "barChartyColor", "barTop", "", "barHeight", "drawComparisonRoundedBar", "brush", "x", "y", "width", "height", "isNegative", "", "isBelowAxisMode", "cornerRadius", "drawComparisonReferenceLineIfNeeded", "comparisonConfig", "Lcom/himanshoe/charty/bar/config/ComparisonBarChartConfig;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "drawComparisonTooltipIfNeeded", "tooltipState", "Lcom/himanshoe/charty/common/tooltip/TooltipState;", "charty_release"})
@SourceDebugExtension(value={"SMAP\nComparisonBarChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComparisonBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/comparison/ComparisonBarChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,186:1\n71#2,3:187\n71#2,5:190\n75#2:195\n33#3:196\n33#3:200\n33#3:204\n33#3:208\n53#4,3:197\n53#4,3:201\n53#4,3:205\n53#4,3:209\n*S KotlinDebug\n*F\n+ 1 ComparisonBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/comparison/ComparisonBarChartDrawerKt\n*L\n24#1:187,3\n28#1:190,5\n24#1:195\n135#1:196\n136#1:200\n146#1:204\n147#1:208\n135#1:197,3\n136#1:201,3\n146#1:205,3\n147#1:209,3\n*E\n"})
public final class ComparisonBarChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawComparisonBars(@NotNull DrawScope $this$drawComparisonBars, @NotNull ComparisonBarDrawParams params) {
        Intrinsics.checkNotNullParameter((Object)$this$drawComparisonBars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<BarGroup> $this$fastForEachIndexed$iv = params.getDataList();
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void group;
            BarGroup item$iv;
            BarGroup barGroup = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int groupIndex = index$iv;
            boolean bl = false;
            float groupWidth = params.getChartContext().getWidth() / (float)params.getDataList().size();
            float barWidth = groupWidth / (float)group.getValues().size() * 0.8f;
            List<Float> $this$fastForEachIndexed$iv2 = group.getValues();
            boolean $i$f$fastForEachIndexed2 = false;
            int n2 = ((Collection)$this$fastForEachIndexed$iv2).size();
            for (int index$iv2 = 0; index$iv2 < n2; ++index$iv2) {
                void value;
                Float item$iv2 = $this$fastForEachIndexed$iv2.get(index$iv2);
                float f = ((Number)item$iv2).floatValue();
                int barIndex = index$iv2;
                boolean bl2 = false;
                float barX = ComparisonBarChartHelpersKt.calculateComparisonBarX(params.getChartContext(), groupWidth, groupIndex, barWidth, barIndex);
                float barValueY = params.getChartContext().convertValueToYPosition((float)value);
                boolean isNegative = value < 0.0f;
                Pair<Float, Float> pair = ComparisonBarChartHelpersKt.calculateComparisonBarDimensions((float)value, params.getBaselineY(), barValueY);
                float barTop = ((Number)pair.component1()).floatValue();
                float barHeight = ((Number)pair.component2()).floatValue();
                if (params.getOnBarClick() != null) {
                    params.getBarBounds().add((Pair<Rect, ComparisonBarSegment>)TuplesKt.to((Object)new Rect(barX, barTop, barX + barWidth, barTop + barHeight), (Object)new ComparisonBarSegment((BarGroup)group, barIndex, (float)value)));
                }
                ChartyColor barChartyColor = ComparisonBarChartDrawerKt.getComparisonBarColor((BarGroup)group, barIndex);
                Brush barBrush = ComparisonBarChartDrawerKt.createComparisonBarBrush(barChartyColor, barTop, barHeight);
                ComparisonBarChartDrawerKt.drawComparisonRoundedBar($this$drawComparisonBars, barBrush, barX, barTop, barWidth, barHeight, isNegative, params.getComparisonConfig().getNegativeValuesDrawMode() == NegativeValuesDrawMode.BELOW_AXIS, params.getComparisonConfig().getCornerRadius().getValue());
            }
        }
    }

    private static final ChartyColor getComparisonBarColor(BarGroup group, int barIndex) {
        if (!(group.getColors() != null)) {
            boolean $i$a$-require-ComparisonBarChartDrawerKt$getComparisonBarColor$32 = false;
            String $i$a$-require-ComparisonBarChartDrawerKt$getComparisonBarColor$32 = "ComparisonBarChart requires each BarGroup to specify colors. Please set the 'colors' property in BarGroup.";
            throw new IllegalArgumentException($i$a$-require-ComparisonBarChartDrawerKt$getComparisonBarColor$32.toString());
        }
        if (!(barIndex < group.getColors().size())) {
            boolean bl = false;
            String string2 = "BarGroup '" + group.getLabel() + "' has " + group.getValues().size() + " values but only " + group.getColors().size() + " colors. Please provide a color for each value.";
            throw new IllegalArgumentException(string2.toString());
        }
        return group.getColors().get(barIndex);
    }

    private static final Brush createComparisonBarBrush(ChartyColor barChartyColor, float barTop, float barHeight) {
        Brush brush;
        ChartyColor chartyColor = barChartyColor;
        if (chartyColor instanceof ChartyColor.Solid) {
            Object[] objectArray = new Color[]{Color.box-impl((long)((ChartyColor.Solid)barChartyColor).getColor-0d7_KjU()), Color.box-impl((long)((ChartyColor.Solid)barChartyColor).getColor-0d7_KjU())};
            brush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, (List)CollectionsKt.listOf((Object[])objectArray), (float)barTop, (float)(barTop + barHeight), (int)0, (int)8, null);
        } else if (chartyColor instanceof ChartyColor.Gradient) {
            brush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, ((ChartyColor.Gradient)barChartyColor).getColors(), (float)barTop, (float)(barTop + barHeight), (int)0, (int)8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return brush;
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawComparisonRoundedBar(DrawScope $this$drawComparisonRoundedBar, Brush brush, float x, float y, float width, float height, boolean isNegative, boolean isBelowAxisMode, float cornerRadius) {
        Path path;
        Path $this$drawComparisonRoundedBar_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        if (isNegative && isBelowAxisMode) {
            void x$iv;
            void x$iv2;
            float f = x + width;
            float f2 = y + height;
            long l = CornerRadius.Companion.getZero-kKHJgLs();
            long l2 = CornerRadius.Companion.getZero-kKHJgLs();
            float f3 = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius22 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv2);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l3 = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            float $i$f$CornerRadius22 = cornerRadius;
            float y$iv2 = cornerRadius;
            boolean $i$f$CornerRadius = false;
            boolean $i$f$packFloats2 = false;
            long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
            long l4 = CornerRadius.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
            Path.addRoundRect$default((Path)$this$drawComparisonRoundedBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f2, l, l2, l4, l3, null), null, (int)2, null);
        } else {
            void x$iv;
            void x$iv3;
            float f = x + width;
            float f4 = y + height;
            float f5 = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius32 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv3);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            float $i$f$CornerRadius32 = cornerRadius;
            float y$iv3 = cornerRadius;
            boolean $i$f$CornerRadius = false;
            boolean $i$f$packFloats3 = false;
            long v1$iv$iv3 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv3 = Float.floatToRawIntBits(y$iv3);
            long l5 = CornerRadius.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv3 & 0xFFFFFFFFL));
            long l6 = CornerRadius.Companion.getZero-kKHJgLs();
            long l7 = CornerRadius.Companion.getZero-kKHJgLs();
            Path.addRoundRect$default((Path)$this$drawComparisonRoundedBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f4, l, l5, l7, l6, null), null, (int)2, null);
        }
        Path path2 = path;
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawComparisonRoundedBar, (Path)path2, (Brush)brush, (float)0.0f, null, null, (int)0, (int)60, null);
    }

    public static final void drawComparisonReferenceLineIfNeeded(@NotNull DrawScope $this$drawComparisonReferenceLineIfNeeded, @NotNull ComparisonBarChartConfig comparisonConfig, @NotNull ChartContext chartContext, @NotNull TextMeasurer textMeasurer) {
        Intrinsics.checkNotNullParameter((Object)$this$drawComparisonReferenceLineIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)comparisonConfig, (String)"comparisonConfig");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        ChartDrawUtilsKt.drawReferenceLineIfNeeded($this$drawComparisonReferenceLineIfNeeded, comparisonConfig.getReferenceLine(), chartContext, ChartOrientation.VERTICAL, textMeasurer);
    }

    public static final void drawComparisonTooltipIfNeeded(@NotNull DrawScope $this$drawComparisonTooltipIfNeeded, @Nullable TooltipState tooltipState, @NotNull ComparisonBarChartConfig comparisonConfig, @NotNull TextMeasurer textMeasurer, @NotNull ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)$this$drawComparisonTooltipIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)comparisonConfig, (String)"comparisonConfig");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        ChartDrawUtilsKt.drawTooltipIfNeeded($this$drawComparisonTooltipIfNeeded, tooltipState, comparisonConfig.getTooltipConfig(), textMeasurer, chartContext);
    }
}

