/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.horizontal;

import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.axis.AxisConfig;
import com.himanshoe.charty.common.config.ChartScaffoldConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0000\u001a0\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a<\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0000\u00a8\u0006\u0015"}, d2={"createHorizontalAxisConfig", "Lcom/himanshoe/charty/common/axis/AxisConfig;", "minValue", "", "maxValue", "drawAxisAtZero", "", "calculateHorizontalAxisOffset", "scaffoldConfig", "Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;", "calculateHorizontalBaselineX", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "axisOffset", "calculateHorizontalBarDimensions", "Lkotlin/Pair;", "isNegative", "isBelowAxisMode", "baselineX", "barValueX", "animationProgress", "charty_release"})
public final class HorizontalBarChartHelpersKt {
    @NotNull
    public static final AxisConfig createHorizontalAxisConfig(float minValue, float maxValue, boolean drawAxisAtZero) {
        return new AxisConfig(minValue, maxValue, 6, null, drawAxisAtZero, 8, null);
    }

    public static final float calculateHorizontalAxisOffset(@NotNull ChartScaffoldConfig scaffoldConfig) {
        Intrinsics.checkNotNullParameter((Object)scaffoldConfig, (String)"scaffoldConfig");
        return scaffoldConfig.getShowAxis() ? scaffoldConfig.getAxisThickness() * 20.0f : 0.0f;
    }

    public static final float calculateHorizontalBaselineX(boolean drawAxisAtZero, float minValue, float maxValue, @NotNull ChartContext chartContext, float axisOffset) {
        float f;
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        if (drawAxisAtZero) {
            float range = maxValue - minValue;
            float zeroNormalized = (0.0f - minValue) / range;
            f = chartContext.getLeft() + zeroNormalized * chartContext.getWidth();
        } else {
            f = chartContext.getLeft() + axisOffset;
        }
        return f;
    }

    @NotNull
    public static final Pair<Float, Float> calculateHorizontalBarDimensions(boolean isNegative, boolean isBelowAxisMode, float baselineX, float barValueX, float animationProgress) {
        Pair pair;
        if (isNegative && isBelowAxisMode) {
            float fullBarWidth = baselineX - barValueX;
            float barWidth = fullBarWidth * animationProgress;
            float barLeft = barValueX;
            pair = TuplesKt.to((Object)Float.valueOf(barLeft), (Object)Float.valueOf(barWidth));
        } else {
            float fullBarWidth = barValueX - baselineX;
            float barWidth = fullBarWidth * animationProgress;
            float barLeft = baselineX;
            pair = TuplesKt.to((Object)Float.valueOf(barLeft), (Object)Float.valueOf(barWidth));
        }
        return pair;
    }
}

