/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.line.internal.multiline;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.config.Animation;
import com.himanshoe.charty.line.config.LineChartConfig;
import com.himanshoe.charty.line.data.LineGroup;
import com.himanshoe.charty.line.data.MultilinePoint;
import com.himanshoe.charty.line.internal.multiline.MultilineChartHelpersKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001ad\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0010\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0018\u00010\u0011H\u0000\u001a@\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001aj\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0010\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0018\u00010\u0011H\u0002\u00a8\u0006\u0018"}, d2={"drawLineSeries", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "seriesIndex", "", "dataList", "", "Lcom/himanshoe/charty/line/data/LineGroup;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "lineConfig", "Lcom/himanshoe/charty/line/config/LineChartConfig;", "colorList", "Landroidx/compose/ui/graphics/Color;", "animationProgress", "", "pointBounds", "", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Offset;", "Lcom/himanshoe/charty/line/data/MultilinePoint;", "drawLineForSeries", "pointPositions", "drawPointsForSeries", "charty_release"})
@SourceDebugExtension(value={"SMAP\nMultilineChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineChartDrawer.kt\ncom/himanshoe/charty/line/internal/multiline/MultilineChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,128:1\n71#2,5:129\n*S KotlinDebug\n*F\n+ 1 MultilineChartDrawer.kt\ncom/himanshoe/charty/line/internal/multiline/MultilineChartDrawerKt\n*L\n96#1:129,5\n*E\n"})
public final class MultilineChartDrawerKt {
    public static final void drawLineSeries(@NotNull DrawScope $this$drawLineSeries, int seriesIndex, @NotNull List<LineGroup> dataList, @NotNull ChartContext chartContext, @NotNull LineChartConfig lineConfig, @NotNull List<Color> colorList, float animationProgress, @Nullable List<Pair<Offset, MultilinePoint>> pointBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$drawLineSeries, (String)"<this>");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)lineConfig, (String)"lineConfig");
        Intrinsics.checkNotNullParameter(colorList, (String)"colorList");
        List<Offset> pointPositions = MultilineChartHelpersKt.calculateSeriesPointPositions(chartContext, dataList, seriesIndex);
        if (!((Collection)pointPositions).isEmpty()) {
            MultilineChartDrawerKt.drawLineForSeries($this$drawLineSeries, pointPositions, chartContext, lineConfig, colorList, animationProgress);
        }
        if (lineConfig.getShowPoints()) {
            MultilineChartDrawerKt.drawPointsForSeries($this$drawLineSeries, pointPositions, seriesIndex, dataList, lineConfig, colorList, animationProgress, pointBounds);
        }
    }

    private static final void drawLineForSeries(DrawScope $this$drawLineForSeries, List<Offset> pointPositions, ChartContext chartContext, LineChartConfig lineConfig, List<Color> colorList, float animationProgress) {
        Path path = AndroidPath_androidKt.Path();
        float startX = chartContext.getLeft();
        float startY = chartContext.getBottom();
        if (lineConfig.getSmoothCurve()) {
            MultilineChartHelpersKt.drawSmoothMultiline(path, pointPositions, startX, startY);
        } else {
            MultilineChartHelpersKt.drawStraightMultiline(path, pointPositions, startX, startY);
        }
        Brush brush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, colorList, (float)0.0f, (float)0.0f, (int)0, (int)14, null);
        Stroke stroke = new Stroke(lineConfig.getLineWidth(), 0.0f, lineConfig.getStrokeCap-KaPHkGw(), 0, null, 26, null);
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawLineForSeries, (Path)path, (Brush)brush, (float)animationProgress, (DrawStyle)((DrawStyle)stroke), null, (int)0, (int)48, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawPointsForSeries(DrawScope $this$drawPointsForSeries, List<Offset> pointPositions, int seriesIndex, List<LineGroup> dataList, LineChartConfig lineConfig, List<Color> colorList, float animationProgress, List<Pair<Offset, MultilinePoint>> pointBounds) {
        List<Offset> $this$fastForEachIndexed$iv = pointPositions;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void position;
            float pointProgress;
            Offset item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            long l = item$iv.unbox-impl();
            int index = index$iv;
            boolean bl = false;
            float f = pointProgress = lineConfig.getAnimation() instanceof Animation.Enabled ? RangesKt.coerceAtMost((float)((float)(index + 1) / (float)pointPositions.size()), (float)(animationProgress * 1.2f)) : 1.0f;
            if (!(pointProgress > 0.0f)) continue;
            if (pointBounds != null) {
                LineGroup group = dataList.get(index);
                Float f2 = (Float)CollectionsKt.getOrNull(group.getValues(), (int)seriesIndex);
                float value = f2 != null ? f2.floatValue() : 0.0f;
                pointBounds.add((Pair<Offset, MultilinePoint>)TuplesKt.to((Object)Offset.box-impl((long)position), (Object)new MultilinePoint(group, seriesIndex, index, value)));
            }
            DrawScope.drawCircle-V9BoPsw$default((DrawScope)$this$drawPointsForSeries, (Brush)Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, colorList, (float)0.0f, (float)0.0f, (int)0, (int)14, null), (float)lineConfig.getPointRadius(), (long)position, (float)(RangesKt.coerceIn((float)pointProgress, (float)0.0f, (float)1.0f) * lineConfig.getPointAlpha()), null, null, (int)0, (int)112, null);
        }
    }
}

