/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.point;

import androidx.compose.foundation.gestures.TapGestureDetectorKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputEventHandler;
import androidx.compose.ui.input.pointer.PointerInputScope;
import androidx.compose.ui.input.pointer.SuspendingPointerInputFilterKt;
import com.himanshoe.charty.common.gesture.GestureUtilsKt;
import com.himanshoe.charty.common.util.ValueCalculationsKt;
import com.himanshoe.charty.point.BubbleBounds;
import com.himanshoe.charty.point.BubbleChartExtKt;
import com.himanshoe.charty.point.BubbleSizeInfo;
import com.himanshoe.charty.point.data.BubbleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a0\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a:\u0010\r\u001a\u00020\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEFAULT_NORMALIZED_SIZE", "", "calculateBubbleSizeInfo", "Lcom/himanshoe/charty/point/BubbleSizeInfo;", "dataList", "", "Lcom/himanshoe/charty/point/data/BubbleData;", "calculateBubbleRadius", "bubbleSize", "minSize", "sizeRange", "minBubbleRadius", "maxBubbleRadius", "createBubbleClickModifier", "Landroidx/compose/ui/Modifier;", "bubbleBounds", "Lcom/himanshoe/charty/point/BubbleBounds;", "onBubbleClick", "Lkotlin/Function1;", "", "charty_release"})
@SourceDebugExtension(value={"SMAP\nBubbleChartExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BubbleChartExt.kt\ncom/himanshoe/charty/point/BubbleChartExtKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1563#2:125\n1634#2,3:126\n1563#2:129\n1634#2,3:130\n*S KotlinDebug\n*F\n+ 1 BubbleChartExt.kt\ncom/himanshoe/charty/point/BubbleChartExtKt\n*L\n55#1:125\n55#1:126,3\n56#1:129\n56#1:130,3\n*E\n"})
public final class BubbleChartExtKt {
    public static final float DEFAULT_NORMALIZED_SIZE = 0.5f;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BubbleSizeInfo calculateBubbleSizeInfo(@NotNull List<BubbleData> dataList) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Iterable $this$map$iv = dataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            BubbleData bubbleData = (BubbleData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(it.getYValue()));
        }
        List yValues = (List)destination$iv$iv;
        Iterable $this$map$iv2 = dataList;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BubbleData bl = (BubbleData)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(Float.valueOf(it.getSize()));
        }
        List sizes = (List)destination$iv$iv2;
        Float f = CollectionsKt.minOrNull((Iterable)sizes);
        float min = f != null ? f.floatValue() : 0.0f;
        Float f2 = CollectionsKt.maxOrNull((Iterable)sizes);
        float max = f2 != null ? f2.floatValue() : 1.0f;
        return new BubbleSizeInfo(ValueCalculationsKt.calculateMinValue$default(yValues, 0, 2, null), ValueCalculationsKt.calculateMaxValue$default(yValues, 0, 2, null), min, max, max - min);
    }

    public static final float calculateBubbleRadius(float bubbleSize, float minSize, float sizeRange, float minBubbleRadius, float maxBubbleRadius) {
        float normalizedSize = sizeRange > 0.0f ? (bubbleSize - minSize) / sizeRange : 0.5f;
        float radiusRange = maxBubbleRadius - minBubbleRadius;
        return minBubbleRadius + (float)Math.sqrt(normalizedSize) * radiusRange;
    }

    @NotNull
    public static final Modifier createBubbleClickModifier(@NotNull List<BubbleData> dataList, @NotNull List<BubbleBounds> bubbleBounds, @Nullable Function1<? super BubbleData, Unit> onBubbleClick) {
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter(bubbleBounds, (String)"bubbleBounds");
        return onBubbleClick != null ? SuspendingPointerInputFilterKt.pointerInput((Modifier)((Modifier)Modifier.Companion), dataList, onBubbleClick, (PointerInputEventHandler)new PointerInputEventHandler(bubbleBounds, onBubbleClick){
            final /* synthetic */ List<BubbleBounds> $bubbleBounds;
            final /* synthetic */ Function1<BubbleData, Unit> $onBubbleClick;
            {
                this.$bubbleBounds = $bubbleBounds;
                this.$onBubbleClick = $onBubbleClick;
            }

            public final Object invoke(PointerInputScope $this$pointerInput, Continuation<? super Unit> $completion) {
                Object object = TapGestureDetectorKt.detectTapGestures$default((PointerInputScope)$this$pointerInput, null, null, null, arg_0 -> createBubbleClickModifier.1.invoke$lambda$0(this.$bubbleBounds, this.$onBubbleClick, arg_0), $completion, (int)7, null);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            private static final Unit invoke$lambda$0(List $bubbleBounds, Function1 $onBubbleClick, Offset tapOffset) {
                block2: {
                    BubbleBounds clickedBubble;
                    Object v0;
                    block1: {
                        Iterable iterable = $bubbleBounds;
                        for (T t : iterable) {
                            BubbleBounds bubble = (BubbleBounds)t;
                            boolean bl = false;
                            float distance = GestureUtilsKt.calculateDistance-0a9Yr6o(bubble.getCenter-F1C5BW0(), tapOffset.unbox-impl());
                            if (!(distance <= bubble.getRadius())) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    BubbleBounds bubbleBounds = clickedBubble = (BubbleBounds)v0;
                    if (bubbleBounds == null) break block2;
                    BubbleBounds bubble = bubbleBounds;
                    boolean bl = false;
                    $onBubbleClick.invoke((Object)bubble.getData());
                }
                return Unit.INSTANCE;
            }
        }) : (Modifier)Modifier.Companion;
    }
}

