/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.point;

import androidx.compose.animation.core.Animatable;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.bar.config.NegativeValuesDrawMode;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.color.ChartyColors;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.ChartScaffoldKt;
import com.himanshoe.charty.common.animation.AnimationHelperKt;
import com.himanshoe.charty.common.axis.AxisConfig;
import com.himanshoe.charty.common.axis.LabelRotation;
import com.himanshoe.charty.common.config.ChartScaffoldConfig;
import com.himanshoe.charty.point.BubbleBounds;
import com.himanshoe.charty.point.BubbleChartExtKt;
import com.himanshoe.charty.point.BubbleSizeInfo;
import com.himanshoe.charty.point.config.PointChartConfig;
import com.himanshoe.charty.point.data.BubbleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001ak\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"BubbleChart", "", "data", "Lkotlin/Function0;", "", "Lcom/himanshoe/charty/point/data/BubbleData;", "modifier", "Landroidx/compose/ui/Modifier;", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "config", "Lcom/himanshoe/charty/point/config/PointChartConfig;", "scaffoldConfig", "Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;", "minBubbleRadius", "", "onBubbleClick", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/Modifier;Lcom/himanshoe/charty/color/ChartyColor;Lcom/himanshoe/charty/point/config/PointChartConfig;Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;FLkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;II)V", "charty_release"})
@SourceDebugExtension(value={"SMAP\nBubbleChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BubbleChart.kt\ncom/himanshoe/charty/point/BubbleChartKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 7 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,128:1\n1282#2,6:129\n1282#2,6:136\n1282#2,6:142\n1282#2,6:152\n1#3:135\n1563#4:148\n1634#4,3:149\n71#5,3:158\n75#5:165\n30#6:161\n53#7,3:162\n*S KotlinDebug\n*F\n+ 1 BubbleChart.kt\ncom/himanshoe/charty/point/BubbleChartKt\n*L\n59#1:129,6\n64#1:136,6\n65#1:142,6\n81#1:152,6\n73#1:148\n73#1:149,3\n84#1:158,3\n84#1:165\n105#1:161\n105#1:162,3\n*E\n"})
public final class BubbleChartKt {
    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void BubbleChart(@NotNull Function0<? extends List<BubbleData>> data, @Nullable Modifier modifier, @Nullable ChartyColor color, @Nullable PointChartConfig config, @Nullable ChartScaffoldConfig scaffoldConfig, float minBubbleRadius, @Nullable Function1<? super BubbleData, Unit> onBubbleClick, @Nullable Composer $composer, int $changed, int n) {
        block40: {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            $composer = $composer.startRestartGroup(211693110);
            ComposerKt.sourceInformation((Composer)$composer, (String)"C(BubbleChart)N(data,modifier,color,config,scaffoldConfig,minBubbleRadius,onBubbleClick)58@2673L25,63@2976L42,64@3038L56,68@3218L40,80@3661L1780,70@3264L2177:BubbleChart.kt#hfrmzw");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(data) ? 4 : 2;
            }
            if ((n & 2) != 0) {
                $dirty |= 0x30;
            } else if (($changed & 0x30) == 0) {
                $dirty |= $composer.changed((Object)modifier) ? 32 : 16;
            }
            if (($changed & 0x180) == 0) {
                $dirty |= (n & 4) == 0 && $composer.changed((Object)color) ? 256 : 128;
            }
            if (($changed & 0xC00) == 0) {
                $dirty |= (n & 8) == 0 && $composer.changedInstance((Object)config) ? 2048 : 1024;
            }
            if (($changed & 0x6000) == 0) {
                $dirty |= (n & 0x10) == 0 && $composer.changed((Object)scaffoldConfig) ? 16384 : 8192;
            }
            if ((n & 0x20) != 0) {
                $dirty |= 0x30000;
            } else if (($changed & 0x30000) == 0) {
                $dirty |= $composer.changed(minBubbleRadius) ? 131072 : 65536;
            }
            if ((n & 0x40) != 0) {
                $dirty |= 0x180000;
            } else if (($changed & 0x180000) == 0) {
                $dirty |= $composer.changedInstance(onBubbleClick) ? 0x100000 : 524288;
            }
            if ($composer.shouldExecute(($dirty & 0x92493) != 599186, $dirty & 1)) {
                Object object;
                void $this$cache$iv;
                Collection collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object2;
                void $this$cache$iv2;
                Object object3;
                BubbleSizeInfo $this$cache$iv3;
                Object object4;
                List value$iv;
                void $this$cache$iv4;
                $composer.startDefaults();
                if (($changed & 1) == 0 || $composer.getDefaultsInvalid()) {
                    if ((n & 2) != 0) {
                        modifier = (Modifier)Modifier.Companion;
                    }
                    if ((n & 4) != 0) {
                        color = new ChartyColor.Solid(ChartyColors.INSTANCE.getBlue-0d7_KjU(), null);
                        $dirty &= 0xFFFFFC7F;
                    }
                    if ((n & 8) != 0) {
                        config = new PointChartConfig(0.0f, 0.0f, false, null, null, null, null, null, null, 511, null);
                        $dirty &= 0xFFFFE3FF;
                    }
                    if ((n & 0x10) != 0) {
                        scaffoldConfig = new ChartScaffoldConfig(false, false, false, 0L, null, 0L, 0.0f, 0.0f, null, 511, null);
                        $dirty &= 0xFFFF1FFF;
                    }
                    if ((n & 0x20) != 0) {
                        minBubbleRadius = 10.0f;
                    }
                    if ((n & 0x40) != 0) {
                        onBubbleClick = null;
                    }
                } else {
                    $composer.skipToGroupEnd();
                    if ((n & 4) != 0) {
                        $dirty &= 0xFFFFFC7F;
                    }
                    if ((n & 8) != 0) {
                        $dirty &= 0xFFFFE3FF;
                    }
                    if ((n & 0x10) != 0) {
                        $dirty &= 0xFFFF1FFF;
                    }
                }
                $composer.endDefaults();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)211693110, (int)$dirty, (int)-1, (String)"com.himanshoe.charty.point.BubbleChart (BubbleChart.kt:57)");
                }
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)1573627759, (String)"CC(remember):BubbleChart.kt#9igjgp");
                Composer composer = $composer;
                boolean invalid$iv22 = ($dirty & 0xE) == 4;
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv4.rememberedValue();
                boolean bl = false;
                if (invalid$iv22 || it$iv == Composer.Companion.getEmpty()) {
                    boolean bl2 = false;
                    value$iv = (List)data.invoke();
                    $this$cache$iv4.updateRememberedValue((Object)value$iv);
                    object4 = value$iv;
                } else {
                    object4 = it$iv;
                }
                List list = (List)object4;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                List dataList = list;
                if (!(!((Collection)dataList).isEmpty())) {
                    boolean $i$a$-require-BubbleChartKt$BubbleChart$42 = false;
                    String $i$a$-require-BubbleChartKt$BubbleChart$42 = "Bubble chart data cannot be empty";
                    throw new IllegalArgumentException($i$a$-require-BubbleChartKt$BubbleChart$42.toString());
                }
                if (!(minBubbleRadius > 0.0f)) {
                    boolean $i$a$-require-BubbleChartKt$BubbleChart$52 = false;
                    String $i$a$-require-BubbleChartKt$BubbleChart$52 = "Minimum bubble radius must be positive";
                    throw new IllegalArgumentException($i$a$-require-BubbleChartKt$BubbleChart$52.toString());
                }
                if (!(config.getPointRadius() > minBubbleRadius)) {
                    boolean $i$a$-require-BubbleChartKt$BubbleChart$62 = false;
                    String $i$a$-require-BubbleChartKt$BubbleChart$62 = "Max radius must be greater than min radius";
                    throw new IllegalArgumentException($i$a$-require-BubbleChartKt$BubbleChart$62.toString());
                }
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)1573637472, (String)"CC(remember):BubbleChart.kt#9igjgp");
                Composer invalid$iv22 = $composer;
                boolean invalid$iv32 = false;
                boolean $i$f$cache2 = false;
                Object it$iv2 = $this$cache$iv3.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (it$iv2 == Composer.Companion.getEmpty()) {
                    boolean bl3 = false;
                    value$iv = new ArrayList();
                    $this$cache$iv3.updateRememberedValue(value$iv);
                    object3 = value$iv;
                } else {
                    object3 = it$iv2;
                }
                List $i$a$-require-BubbleChartKt$BubbleChart$62 = (List)object3;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                List bubbleBounds = $i$a$-require-BubbleChartKt$BubbleChart$62;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)1573639470, (String)"CC(remember):BubbleChart.kt#9igjgp");
                Composer invalid$iv32 = $composer;
                boolean invalid$iv42 = $composer.changed((Object)dataList);
                boolean $i$f$cache3 = false;
                Object it$iv3 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv42 || it$iv3 == Composer.Companion.getEmpty()) {
                    boolean bl4 = false;
                    BubbleSizeInfo value$iv2 = BubbleChartExtKt.calculateBubbleSizeInfo(dataList);
                    $this$cache$iv2.updateRememberedValue((Object)value$iv2);
                    object2 = value$iv2;
                } else {
                    object2 = it$iv3;
                }
                $this$cache$iv3 = (BubbleSizeInfo)object2;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                BubbleSizeInfo sizeInfo = $this$cache$iv3;
                boolean isBelowAxisMode = config.getNegativeValuesDrawMode() == NegativeValuesDrawMode.BELOW_AXIS;
                Animatable<Float, ?> animationProgress = AnimationHelperKt.rememberChartAnimation(config.getAnimation(), null, 0.0f, $composer, 0, 6);
                Iterable invalid$iv42 = dataList;
                Modifier modifier2 = modifier.then(BubbleChartExtKt.createBubbleClickModifier(dataList, bubbleBounds, onBubbleClick));
                boolean $i$f$map22 = false;
                it$iv3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BubbleData bubbleData = (BubbleData)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(it.getLabel());
                }
                Collection collection2 = (List)destination$iv$iv;
                Modifier modifier3 = modifier2;
                AxisConfig axisConfig = new AxisConfig(sizeInfo.getMinValue(), sizeInfo.getMaxValue(), 6, null, isBelowAxisMode, 8, null);
                ChartScaffoldConfig chartScaffoldConfig = scaffoldConfig;
                ChartOrientation chartOrientation = null;
                LabelRotation labelRotation = null;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)1573661130, (String)"CC(remember):BubbleChart.kt#9igjgp");
                Composer $i$f$map22 = $composer;
                boolean invalid$iv = $composer.changedInstance((Object)bubbleBounds) | $composer.changedInstance((Object)dataList) | $composer.changedInstance(animationProgress) | $composer.changed((Object)sizeInfo) | ($dirty & 0x70000) == 131072 | $composer.changedInstance((Object)config) | (($dirty & 0x380 ^ 0x180) > 256 && $composer.changed((Object)color) || ($dirty & 0x180) == 256) | ($dirty & 0x380000) == 0x100000;
                boolean $i$f$cache4 = false;
                Object it$iv4 = $this$cache$iv.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv4 == Composer.Companion.getEmpty()) {
                    LabelRotation labelRotation2 = labelRotation;
                    ChartOrientation chartOrientation2 = chartOrientation;
                    ChartScaffoldConfig chartScaffoldConfig2 = chartScaffoldConfig;
                    AxisConfig axisConfig2 = axisConfig;
                    collection = collection2;
                    modifier2 = modifier3;
                    boolean bl6 = false;
                    Function2 function2 = (arg_0, arg_1) -> BubbleChartKt.BubbleChart$lambda$7$0(bubbleBounds, dataList, animationProgress, sizeInfo, minBubbleRadius, config, color, onBubbleClick, arg_0, arg_1);
                    modifier3 = modifier2;
                    collection2 = collection;
                    axisConfig = axisConfig2;
                    chartScaffoldConfig = chartScaffoldConfig2;
                    chartOrientation = chartOrientation2;
                    labelRotation = labelRotation2;
                    Function2 value$iv3 = function2;
                    $this$cache$iv.updateRememberedValue((Object)value$iv3);
                    object = value$iv3;
                } else {
                    object = it$iv4;
                }
                Function2 function2 = (Function2)object;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                ChartScaffoldKt.ChartScaffold(modifier3, collection2, axisConfig, chartScaffoldConfig, chartOrientation, labelRotation, (Function2<? super DrawScope, ? super ChartContext, Unit>)function2, $composer, 0x1C00 & $dirty >> 3, 48);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block40;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> BubbleChartKt.BubbleChart$lambda$8(data, modifier, color, config, scaffoldConfig, minBubbleRadius, onBubbleClick, $changed, n, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit BubbleChart$lambda$7$0(List $bubbleBounds, List $dataList, Animatable $animationProgress, BubbleSizeInfo $sizeInfo, float $minBubbleRadius, PointChartConfig $config, ChartyColor $color, Function1 $onBubbleClick, DrawScope $this$ChartScaffold, ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)$this$ChartScaffold, (String)"$this$ChartScaffold");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        $bubbleBounds.clear();
        List $this$fastForEachIndexed$iv = $dataList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void x$iv;
            long l;
            void bubble;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            BubbleData bubbleData = (BubbleData)item$iv;
            int index = index$iv;
            boolean bl = false;
            float bubbleProgress = (float)index / (float)$dataList.size();
            float bubbleAnimationProgress = RangesKt.coerceIn((float)((((Number)$animationProgress.getValue()).floatValue() - bubbleProgress) * (float)$dataList.size()), (float)0.0f, (float)1.0f);
            float bubbleX = chartContext.calculateCenteredXPosition(index, $dataList.size());
            float bubbleY = chartContext.convertValueToYPosition(bubble.getYValue());
            float bubbleRadius = BubbleChartExtKt.calculateBubbleRadius(bubble.getSize(), $sizeInfo.getMinSize(), $sizeInfo.getSizeRange(), $minBubbleRadius, $config.getPointRadius());
            ChartyColor chartyColor = $color;
            if (chartyColor instanceof ChartyColor.Solid) {
                l = ((ChartyColor.Solid)$color).getColor-0d7_KjU();
            } else if (chartyColor instanceof ChartyColor.Gradient) {
                l = ((ChartyColor.Gradient)$color).getColors().get(index % ((ChartyColor.Gradient)$color).getColors().size()).unbox-impl();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            long bubbleColor = l;
            if (!(bubbleAnimationProgress > 0.0f)) continue;
            float f = bubbleX;
            float y$iv = bubbleY;
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long center = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            float animatedRadius = bubbleRadius * bubbleAnimationProgress;
            if ($onBubbleClick != null) {
                $bubbleBounds.add(new BubbleBounds(center, animatedRadius, (BubbleData)bubble, null));
            }
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$ChartScaffold, (long)Color.copy-wmQWz5c$default((long)bubbleColor, (float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), (float)animatedRadius, (long)center, (float)($config.getPointAlpha() * bubbleAnimationProgress), null, null, (int)0, (int)112, null);
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$ChartScaffold, (long)bubbleColor, (float)(bubbleRadius * 0.85f * bubbleAnimationProgress), (long)center, (float)($config.getPointAlpha() * bubbleAnimationProgress), null, null, (int)0, (int)112, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit BubbleChart$lambda$8(Function0 $data, Modifier $modifier, ChartyColor $color, PointChartConfig $config, ChartScaffoldConfig $scaffoldConfig, float $minBubbleRadius, Function1 $onBubbleClick, int $$changed, int $$default, Composer $composer, int $force) {
        BubbleChartKt.BubbleChart((Function0<? extends List<BubbleData>>)$data, $modifier, $color, $config, $scaffoldConfig, $minBubbleRadius, (Function1<? super BubbleData, Unit>)$onBubbleClick, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
        return Unit.INSTANCE;
    }
}

