/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.common.axis;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/himanshoe/charty/common/axis/ChartAxisConfig;", "", "xAxisLabels", "", "", "yAxisLabels", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getXAxisLabels", "()Ljava/util/List;", "getYAxisLabels", "ySteps", "", "getYSteps", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "charty_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChartAxisConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartAxisConfig.kt\ncom/himanshoe/charty/common/axis/ChartAxisConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ChartAxisConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> xAxisLabels;
    @NotNull
    private final List<String> yAxisLabels;
    public static final int $stable = 8;

    public ChartAxisConfig(@NotNull List<String> xAxisLabels, @NotNull List<String> yAxisLabels) {
        Intrinsics.checkNotNullParameter(xAxisLabels, (String)"xAxisLabels");
        Intrinsics.checkNotNullParameter(yAxisLabels, (String)"yAxisLabels");
        this.xAxisLabels = xAxisLabels;
        this.yAxisLabels = yAxisLabels;
        if (!(this.yAxisLabels.size() >= 2)) {
            boolean bl = false;
            String string2 = "yAxisLabels must contain at least two entries";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final List<String> getXAxisLabels() {
        return this.xAxisLabels;
    }

    @NotNull
    public final List<String> getYAxisLabels() {
        return this.yAxisLabels;
    }

    public final int getYSteps() {
        return this.yAxisLabels.size() - 1;
    }

    @NotNull
    public final List<String> component1() {
        return this.xAxisLabels;
    }

    @NotNull
    public final List<String> component2() {
        return this.yAxisLabels;
    }

    @NotNull
    public final ChartAxisConfig copy(@NotNull List<String> xAxisLabels, @NotNull List<String> yAxisLabels) {
        Intrinsics.checkNotNullParameter(xAxisLabels, (String)"xAxisLabels");
        Intrinsics.checkNotNullParameter(yAxisLabels, (String)"yAxisLabels");
        return new ChartAxisConfig(xAxisLabels, yAxisLabels);
    }

    public static /* synthetic */ ChartAxisConfig copy$default(ChartAxisConfig chartAxisConfig, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = chartAxisConfig.xAxisLabels;
        }
        if ((n & 2) != 0) {
            list2 = chartAxisConfig.yAxisLabels;
        }
        return chartAxisConfig.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "ChartAxisConfig(xAxisLabels=" + this.xAxisLabels + ", yAxisLabels=" + this.yAxisLabels + ")";
    }

    public int hashCode() {
        int result = ((Object)this.xAxisLabels).hashCode();
        result = result * 31 + ((Object)this.yAxisLabels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChartAxisConfig)) {
            return false;
        }
        ChartAxisConfig chartAxisConfig = (ChartAxisConfig)other;
        if (!Intrinsics.areEqual(this.xAxisLabels, chartAxisConfig.xAxisLabels)) {
            return false;
        }
        return Intrinsics.areEqual(this.yAxisLabels, chartAxisConfig.yAxisLabels);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/himanshoe/charty/common/axis/ChartAxisConfig$Companion;", "", "<init>", "()V", "fromNumericRange", "Lcom/himanshoe/charty/common/axis/ChartAxisConfig;", "xAxisLabels", "", "", "maxValue", "", "stepSize", "", "charty_release"})
    @SourceDebugExtension(value={"SMAP\nChartAxisConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartAxisConfig.kt\ncom/himanshoe/charty/common/axis/ChartAxisConfig$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1563#2:48\n1634#2,3:49\n*S KotlinDebug\n*F\n+ 1 ChartAxisConfig.kt\ncom/himanshoe/charty/common/axis/ChartAxisConfig$Companion\n*L\n42#1:48\n42#1:49,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChartAxisConfig fromNumericRange(@NotNull List<String> xAxisLabels, float maxValue, int stepSize) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(xAxisLabels, (String)"xAxisLabels");
            int safeStep = RangesKt.coerceAtLeast((int)stepSize, (int)1);
            int top = (int)Math.ceil(maxValue / (float)safeStep) * safeStep;
            int steps = top / safeStep;
            Iterable $this$map$iv = (Iterable)new IntRange(0, steps);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void value;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf((int)(value * safeStep)));
            }
            List yLabels = (List)destination$iv$iv;
            return new ChartAxisConfig(xAxisLabels, yLabels);
        }

        public static /* synthetic */ ChartAxisConfig fromNumericRange$default(Companion companion, List list, float f, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 10;
            }
            return companion.fromNumericRange(list, f, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

