/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx;

public abstract class PushDownError {
    String propertyName_;
    PushDownLevel pushDownLevel_;

    public String getPropertyName() {
        return this.propertyName_;
    }

    public abstract ErrorType getErrorType();

    public PushDownLevel getPushDownLevel() {
        return this.pushDownLevel_;
    }

    public static class SQLException
    extends PushDownError {
        private java.sql.SQLException sqlException_;

        public SQLException(String string, PushDownLevel pushDownLevel, java.sql.SQLException sQLException) {
            this.propertyName_ = string;
            this.pushDownLevel_ = pushDownLevel;
            this.sqlException_ = sQLException;
        }

        @Override
        public ErrorType getErrorType() {
            return ErrorType.sqlException;
        }

        public java.sql.SQLException getSQLException() {
            return this.sqlException_;
        }
    }

    public static class UnsupportedPropertyForDynamicPushDown
    extends PushDownError {
        public UnsupportedPropertyForDynamicPushDown(String string, PushDownLevel pushDownLevel) {
            this.propertyName_ = string;
            this.pushDownLevel_ = pushDownLevel;
        }

        @Override
        public ErrorType getErrorType() {
            return ErrorType.unsupportedPropertyForDynamicPushDown;
        }
    }

    public static class UnrecognizedProperty
    extends PushDownError {
        public UnrecognizedProperty(String string, PushDownLevel pushDownLevel) {
            this.propertyName_ = string;
            this.pushDownLevel_ = pushDownLevel;
        }

        @Override
        public ErrorType getErrorType() {
            return ErrorType.unrecognizedProperty;
        }
    }

    public static enum PushDownLevel {
        driver,
        datasource,
        connection,
        database;

    }

    public static enum ErrorType {
        unrecognizedProperty,
        unsupportedPropertyForDynamicPushDown,
        sqlException;

    }
}

