/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.ConnectionImpl;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.LogLookupInfo;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.ProcessingException;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CoreProcessor
implements Processor {
    public static final int version_ = 1;
    private static Logger logger__ = Log.getCMXServerLogger();

    @Override
    public Message processRequest(Message message, CMXConnection cMXConnection) {
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        String string = jSONArray.get(0).toString();
        if (string.equals("1")) {
            return this.parseConnectToProcessorRequest(jSONArray, (ConnectionImpl)cMXConnection);
        }
        throw new ProcessingException("");
    }

    @Override
    public void processAsynchronousMessage(Message message, CMXConnection cMXConnection) throws Exception {
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public String getProcessorName() {
        return "CMXCoreProcessor";
    }

    public void checkForError(Message message) throws Exception {
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        Object e10 = jSONArray.get(0);
        if (e10.equals("2")) {
            String string = (String)jSONArray.get(1);
            int n2 = ((Number)jSONArray.get(2)).intValue();
            throw new Exception("CMXProcessingException occurred on the remote host ERRORCODE=" + n2 + " MESSAGE=" + string);
        }
    }

    public Message createConnectToProcessorRequest(Processor processor) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("1");
        jSONArray.add(processor.getProcessorName());
        jSONArray.add(new Integer(processor.getVersion()));
        Message message = new Message("CMXCoreProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
        return message;
    }

    public static Message createErrorReply(String string, int n2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add("2");
        jSONArray.add(string);
        jSONArray.add((Object)n2);
        Message message = new Message("CMXCoreProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray)));
        return message;
    }

    private Message parseConnectToProcessorRequest(JSONArray jSONArray, ConnectionImpl connectionImpl) {
        int n2;
        Processor processor;
        String string = jSONArray.get(1).toString();
        int n3 = ((Number)jSONArray.get(2)).intValue();
        if (n3 < 0) {
            // empty if block
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "parseConnectToProcessorRequest", "Processor connect request received for processorName: " + string + ", version: " + n3);
        }
        if ((processor = connectionImpl.supportedProcessors_.get(string)) == null) {
            if (logger__.isLoggable(Level.INFO)) {
                DataLogger.lowImpactLogger(logger__, this, "parseConnectToProcessorRequest", "request processor " + string + " not found", null);
            }
            n2 = -1;
        } else {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "parseConnectToProcessorRequest", "Local processor found at version: " + processor.getVersion());
            }
            if ((n2 = processor.getNegotiatedVersion(n3)) < 0 && logger__.isLoggable(Level.INFO)) {
                DataLogger.lowImpactLogger(logger__, this, "parseConnectToProcessorRequest", "Incompatible client version '" + n3 + "' for " + string + " connected from: " + connectionImpl.getSocketChannel().socket().getInetAddress().getHostAddress(), null);
            }
            connectionImpl.connectedProcessorVersions_.put(string, new Integer(n2));
        }
        JSONArray jSONArray2 = new JSONArray();
        jSONArray2.add(new Integer(n2));
        return new Message("CMXCoreProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes(jSONArray2)));
    }

    public int parseConnectReply(Message message) {
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        int n2 = ((Number)jSONArray.get(0)).intValue();
        return n2;
    }

    @Override
    public int getNegotiatedVersion(int n2) {
        return Math.min(n2, this.getVersion());
    }

    @Override
    public Message processRequest(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LogLookupInfo logLookupInfo) throws Exception {
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        String string = jSONArray.get(0).toString();
        if (string.equals("1")) {
            return this.parseConnectToProcessorRequest(jSONArray, httpServletRequest, httpServletResponse);
        }
        throw new ProcessingException("");
    }

    private Message parseConnectToProcessorRequest(JSONArray jSONArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        String string = jSONArray.get(1).toString();
        int n2 = ((Number)jSONArray.get(2)).intValue();
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "parseConnectToProcessorRequest", "Processor connect request received for processorName: " + string + " version: " + n2);
        }
        int n3 = -1;
        if (string != null) {
            if (string.equals("ClientPropertyProcessor")) {
                n3 = Math.min(n2, 12);
            } else if (string.equals("Monitor")) {
                n3 = Math.min(n2, 12);
            } else if (string.equals("CMXCoreProcessor")) {
                n3 = Math.min(n2, 1);
            }
        }
        if (n3 < 0 && logger__ != null) {
            object = httpServletRequest.getHeader("X-Forwarded-For");
            if (object == null) {
                object = httpServletRequest.getRemoteAddr();
            }
            DataLogger.lowImpactLogger(logger__, this, "parseConnectToProcessorRequest", "Incompatible client version '" + n2 + "' for " + string + " connected from: " + (String)object, null);
        }
        httpServletResponse.setHeader("CMX-Client-Processor-Version", Integer.toString(n3));
        object = new JSONArray();
        ((JSONArray)object).add(new Integer(n3));
        return new Message("CMXCoreProcessor", ByteBuffer.wrap(JSONHelper.serializeToBytes((JSONArray)object)));
    }

    @Override
    public void processMessage(Message message, HttpServletRequest httpServletRequest) throws Exception {
    }

    @Override
    public void invokeLogLookup(LogLookupInfo logLookupInfo) {
    }
}

